/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.jline.reader.EndOfFileException;
import org.jline.reader.Expander;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.MaskingCallback;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.neo4j.shell.Historian;
import org.neo4j.shell.completions.DbInfo;
import org.neo4j.shell.exception.NoMoreInputException;
import org.neo4j.shell.log.Logger;
import org.neo4j.shell.parser.StatementParser;
import org.neo4j.shell.printer.AnsiFormattedText;
import org.neo4j.shell.printer.Printer;
import org.neo4j.shell.terminal.CypherShellTerminal;
import org.neo4j.shell.terminal.SimplePrompt;
import org.neo4j.shell.terminal.StatementJlineParser;
import org.neo4j.shell.timeout.IdleTimeoutService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JlineTerminal
implements CypherShellTerminal {
    private static final Logger log = Logger.create();
    static final String NO_CONTINUATION_PROMPT_PATTERN = "  ";
    private final LineReader jLineReader;
    private final Printer printer;
    private final CypherShellTerminal.Reader reader;
    private final CypherShellTerminal.Writer writer;
    private final boolean isInteractive;
    private final DbInfo dbInfo;
    private final Supplier<SimplePrompt> simplePromptSupplier;
    private final IdleTimeoutService exitOnIdleTimeoutService;
    private final IdleTimeoutService stopPollingWhenIdleService;
    private final IdleTimeoutHook idleTimeoutHook;

    public JlineTerminal(LineReader jLineReader, boolean isInteractive, Printer printer, Supplier<SimplePrompt> simplePromptSupplier, Duration idleTimeout, Duration idleDelay, DbInfo dbInfo) {
        assert (jLineReader.getParser() instanceof StatementJlineParser);
        this.jLineReader = jLineReader;
        this.printer = printer;
        this.isInteractive = isInteractive;
        this.simplePromptSupplier = simplePromptSupplier;
        this.reader = new JLineReader();
        this.writer = new JLineWriter();
        this.dbInfo = dbInfo;
        this.exitOnIdleTimeoutService = IdleTimeoutService.create(idleTimeout, idleDelay, () -> {
            System.err.println("Timeout after idling, avoid this by increasing --idle-timeout or omitting it completely.");
            System.exit(124);
        });
        this.stopPollingWhenIdleService = IdleTimeoutService.create(Duration.of(1L, ChronoUnit.MINUTES), Duration.of(30L, ChronoUnit.SECONDS), dbInfo::stopPolling, dbInfo::resumePolling);
        this.idleTimeoutHook = new IdleTimeoutHook();
    }

    private StatementJlineParser getParser() {
        return (StatementJlineParser)this.jLineReader.getParser();
    }

    @Override
    public CypherShellTerminal.Reader read() {
        this.jLineReader.getTerminal().resume();
        return this.reader;
    }

    @Override
    public SimplePrompt simplePrompt() {
        return this.simplePromptSupplier.get();
    }

    @Override
    public CypherShellTerminal.Writer write() {
        return this.writer;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public Historian getHistory() {
        return new JlineHistorian();
    }

    @Override
    public void setHistoryBehaviour(CypherShellTerminal.HistoryBehaviour behaviour) throws IOException {
        if (behaviour instanceof CypherShellTerminal.FileHistory) {
            CypherShellTerminal.FileHistory fileHistory = (CypherShellTerminal.FileHistory)behaviour;
            this.setFileHistory(fileHistory.historyFile());
        } else if (behaviour instanceof CypherShellTerminal.DefaultHistory) {
            this.setFileHistory(Historian.defaultHistoryFile());
        } else if (behaviour instanceof CypherShellTerminal.InMemoryHistory) {
            this.jLineReader.setVariable("history-file", null);
            this.loadHistory();
        } else if (behaviour instanceof CypherShellTerminal.DisableHistory) {
            // empty if block
        }
    }

    private static void safeCreateHistoryFile(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("History file cannot be a directory, please delete " + String.valueOf(path));
        }
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
        }
        if (JlineTerminal.isPosix()) {
            Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rw-------"));
        }
    }

    private static boolean isPosix() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private void setFileHistory(Path file) throws IOException {
        JlineTerminal.safeCreateHistoryFile(file);
        if (!file.equals(this.jLineReader.getVariable("history-file"))) {
            this.jLineReader.setVariable("history-file", (Object)file);
            this.loadHistory();
            Runtime.getRuntime().addShutdownHook(new Thread(this::flushHistory));
        }
    }

    @Override
    public void bindUserInterruptHandler(CypherShellTerminal.UserInterruptHandler handler) {
        this.jLineReader.getTerminal().handle(Terminal.Signal.INT, signal -> handler.handleUserInterrupt());
    }

    private void flushHistory() {
        try {
            this.getHistory().flushHistory();
        }
        catch (IOException e) {
            log.error("Failed to save history", e);
            this.printer.printError("Failed to save history: " + e.getMessage());
        }
    }

    private void loadHistory() {
        try {
            this.jLineReader.getHistory().load();
        }
        catch (IOException e) {
            log.error("Failed to load history", e);
            this.printer.printError("Failed to load history: " + e.getMessage());
        }
    }

    @Override
    public void close() throws Exception {
        this.exitOnIdleTimeoutService.close();
        this.dbInfo.close();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class JLineReader
    implements CypherShellTerminal.Reader {
        private JLineReader() {
        }

        private String readLine(String prompt, boolean mask) throws NoMoreInputException, org.neo4j.shell.exception.UserInterruptException {
            try {
                JlineTerminal.this.stopPollingWhenIdleService.resume();
                JlineTerminal.this.exitOnIdleTimeoutService.resume();
                Object hook = mask ? new MaskingIdleTimeoutHook() : JlineTerminal.this.idleTimeoutHook;
                String string = JlineTerminal.this.jLineReader.readLine(prompt, null, (MaskingCallback)hook, null);
                return string;
            }
            catch (EndOfFileException e) {
                throw new NoMoreInputException();
            }
            catch (UserInterruptException e) {
                throw new org.neo4j.shell.exception.UserInterruptException(e.getPartialLine());
            }
            finally {
                JlineTerminal.this.stopPollingWhenIdleService.pause();
                JlineTerminal.this.exitOnIdleTimeoutService.pause();
            }
        }

        @Override
        public StatementParser.ParsedStatements readStatement(AnsiFormattedText prompt) throws NoMoreInputException, org.neo4j.shell.exception.UserInterruptException {
            JlineTerminal.this.getParser().setEnableStatementParsing(true);
            JlineTerminal.this.jLineReader.setVariable("secondary-prompt-pattern", (Object)this.continuationPromptPattern(prompt));
            String line = this.readLine(prompt.resetAndRender(), false);
            ParsedLine parsed = JlineTerminal.this.jLineReader.getParsedLine();
            if (parsed instanceof ParsedLineStatements) {
                ParsedLineStatements statements = (ParsedLineStatements)parsed;
                if (!statements.line().equals(line)) {
                    throw new IllegalStateException("Unparsed lines do not match");
                }
                return statements.statements();
            }
            throw new IllegalStateException("Unexpected type of parsed line " + parsed.getClass().getSimpleName());
        }

        private String continuationPromptPattern(AnsiFormattedText prompt) {
            if (prompt.textLength() > 50) {
                return JlineTerminal.NO_CONTINUATION_PROMPT_PATTERN;
            }
            return " ".repeat(prompt.textLength());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String simplePrompt(String prompt, boolean mask) throws NoMoreInputException, org.neo4j.shell.exception.UserInterruptException {
            try {
                JlineTerminal.this.jLineReader.getVariables().put("disable-history", Boolean.TRUE);
                JlineTerminal.this.jLineReader.getVariables().put("disable-completion", Boolean.TRUE);
                JlineTerminal.this.getParser().setEnableStatementParsing(false);
                String string = this.readLine(prompt, mask);
                return string;
            }
            finally {
                JlineTerminal.this.jLineReader.getVariables().remove("disable-history");
                JlineTerminal.this.jLineReader.getVariables().remove("disable-completion");
                JlineTerminal.this.getParser().setEnableStatementParsing(true);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class JLineWriter
    implements CypherShellTerminal.Writer {
        private JLineWriter() {
        }

        @Override
        public void println(String line) {
            JlineTerminal.this.jLineReader.printAbove(line + System.lineSeparator());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class IdleTimeoutHook
    implements MaskingCallback {
        private IdleTimeoutHook() {
        }

        public String display(String line) {
            JlineTerminal.this.exitOnIdleTimeoutService.imAwake();
            JlineTerminal.this.stopPollingWhenIdleService.imAwake();
            return line;
        }

        public String history(String line) {
            return line;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class JlineHistorian
    implements Historian {
        private JlineHistorian() {
        }

        @Override
        public List<String> getHistory() {
            JlineTerminal.this.loadHistory();
            return StreamSupport.stream(JlineTerminal.this.jLineReader.getHistory().spliterator(), false).map(History.Entry::line).toList();
        }

        @Override
        public void flushHistory() throws IOException {
            JlineTerminal.this.jLineReader.getHistory().save();
        }

        @Override
        public void clear() throws IOException {
            JlineTerminal.this.jLineReader.getHistory().purge();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface ParsedLineStatements
    extends ParsedLine {
        public StatementParser.ParsedStatements statements();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class MaskingIdleTimeoutHook
    implements MaskingCallback {
        private MaskingIdleTimeoutHook() {
        }

        public String display(String line) {
            JlineTerminal.this.exitOnIdleTimeoutService.imAwake();
            JlineTerminal.this.stopPollingWhenIdleService.imAwake();
            return "*".repeat(line.length());
        }

        public String history(String line) {
            return null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class EmptyExpander
    implements Expander {
        public String expandHistory(History history, String line) {
            return line;
        }

        public String expandVar(String word) {
            return word;
        }
    }
}

