/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.shell.cli.Format;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class StatisticsCollector {
    private Format format;

    public StatisticsCollector(Format format) {
        this.format = format;
    }

    public String collect(ResultSummary summary) {
        if (Format.VERBOSE == this.format) {
            return StatisticsCollector.collectStatistics(summary);
        }
        return "";
    }

    private static String collectStatistics(ResultSummary summary) {
        ArrayList<String> statistics = new ArrayList<String>();
        SummaryCounters counters = summary.counters();
        if (counters == null) {
            return "";
        }
        StatisticsCollector.addStatistic(statistics, Operation.CREATED, counters.nodesCreated(), Element.NODE);
        StatisticsCollector.addStatistic(statistics, Operation.DELETED, counters.nodesDeleted(), Element.NODE);
        StatisticsCollector.addStatistic(statistics, Operation.CREATED, counters.relationshipsCreated(), Element.RELATIONSHIP);
        StatisticsCollector.addStatistic(statistics, Operation.DELETED, counters.relationshipsDeleted(), Element.RELATIONSHIP);
        StatisticsCollector.addStatistic(statistics, Operation.SET, counters.propertiesSet(), Element.PROPERTY);
        StatisticsCollector.addStatistic(statistics, Operation.ADDED, counters.labelsAdded(), Element.LABEL);
        StatisticsCollector.addStatistic(statistics, Operation.REMOVED, counters.labelsRemoved(), Element.LABEL);
        StatisticsCollector.addStatistic(statistics, Operation.ADDED, counters.indexesAdded(), Element.INDEX);
        StatisticsCollector.addStatistic(statistics, Operation.REMOVED, counters.indexesRemoved(), Element.INDEX);
        StatisticsCollector.addStatistic(statistics, Operation.ADDED, counters.constraintsAdded(), Element.CONSTRAINT);
        StatisticsCollector.addStatistic(statistics, Operation.REMOVED, counters.constraintsRemoved(), Element.CONSTRAINT);
        return String.join((CharSequence)", ", statistics);
    }

    private static void addStatistic(List<String> statistics, Operation operation, int number, Element element) {
        if (number > 0) {
            String operationCaseAdjusted = statistics.isEmpty() ? operation.capitalized : operation.lower;
            String elementNumberAdjusted = number == 1 ? element.singular : element.plural;
            statistics.add(String.format("%s %d %s", operationCaseAdjusted, number, elementNumberAdjusted));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Operation {
        ADDED("added", "Added"),
        CREATED("created", "Created"),
        DELETED("deleted", "Deleted"),
        SET("set", "Set"),
        REMOVED("removed", "Removed");

        private final String lower;
        private final String capitalized;

        private Operation(String lower, String capitalized) {
            this.lower = lower;
            this.capitalized = capitalized;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Element {
        NODE("node", "nodes"),
        RELATIONSHIP("relationship", "relationships"),
        PROPERTY("property", "properties"),
        LABEL("label", "labels"),
        INDEX("index", "indexes"),
        CONSTRAINT("constraint", "constraints");

        private final String singular;
        private final String plural;

        private Element(String singular, String plural) {
            this.singular = singular;
            this.plural = plural;
        }
    }
}

