/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.LiteralBase;

@API(status=API.Status.STABLE, since="1.0")
public final class StringLiteral
extends LiteralBase<CharSequence> {
    private static final Pattern RESERVED_CHARS = Pattern.compile("([" + Pattern.quote("\\'\"") + "])");
    private static final String QUOTED_LITERAL_FORMAT = "'%s'";

    StringLiteral(CharSequence content) {
        super(content);
    }

    static Optional<String> escapeString(CharSequence unescapedString) {
        if (unescapedString == null) {
            return Optional.empty();
        }
        StringBuilder buffer = new StringBuilder();
        Matcher matcher = RESERVED_CHARS.matcher(unescapedString);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, "\\\\\\" + matcher.group(1));
        }
        matcher.appendTail(buffer);
        return Optional.of(buffer.toString());
    }

    @Override
    public String asString() {
        Optional<String> escapedContent = StringLiteral.escapeString(this.getContent());
        return String.format(Locale.ENGLISH, QUOTED_LITERAL_FORMAT, escapedContent.orElse(""));
    }

    @Override
    public CharSequence getContent() {
        return (CharSequence)this.content;
    }
}

