/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;

public class RetainLatestUniqueValueCollection<E>
extends AbstractCollection<E> {
    private final HashMap<E, E> map;

    public RetainLatestUniqueValueCollection() {
        this(new HashMap());
    }

    public RetainLatestUniqueValueCollection(Collection<? extends E> collection) {
        this(HashMap.newHashMap(Math.max(collection.size(), 12)));
        this.addAll(collection);
    }

    private RetainLatestUniqueValueCollection(HashMap<E, E> map) {
        assert (map != null && map.isEmpty());
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(Objects.requireNonNull(object));
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.map.values().toArray(array);
    }

    @Override
    public boolean add(E element) {
        this.map.put(Objects.requireNonNull(element), element);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(Objects.requireNonNull(object)) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

