/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ThreadSanitizer {
    public static <T> T sanitize(T toSanitize, Class<T> toSanitizeType, Consumer<Exception> exceptionHandler) {
        Class<?> aClass = toSanitize.getClass();
        return toSanitizeType.cast(Proxy.newProxyInstance(aClass.getClassLoader(), aClass.getInterfaces(), new ProxyInvocationHandler<T>(toSanitize, exceptionHandler)));
    }

    private static class ProxyInvocationHandler<T>
    implements InvocationHandler {
        private final T toSanitize;
        private final Consumer<Exception> exceptionHandler;
        private final AtomicReference<RuntimeException> accessor = new AtomicReference();

        public ProxyInvocationHandler(T toSanitize, Consumer<Exception> exceptionHandler) {
            this.toSanitize = toSanitize;
            this.exceptionHandler = exceptionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            RuntimeException thisAccessorException = new RuntimeException("Concurrent access of thread sanitized method detected.");
            RuntimeException previousAccessorException = this.accessor.compareAndExchange(null, thisAccessorException);
            if (previousAccessorException != null) {
                this.exceptionHandler.accept(previousAccessorException);
                this.exceptionHandler.accept(thisAccessorException);
            }
            try {
                Object object = method.invoke(this.toSanitize, args);
                return object;
            }
            finally {
                this.accessor.set(null);
            }
        }
    }
}

