/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HexFormat;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.internal.helpers.ArrayUtil;

public final class Format {
    static final ZoneId DEFAULT_TIME_ZONE = ZoneOffset.UTC;
    private static final String[] COUNT_SIZES = new String[]{"", "k", "M", "G", "T"};
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    static final String TIME_FORMAT = "HH:mm:ss.SSS";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ").withZone(DEFAULT_TIME_ZONE);
    private static final DateTimeFormatter LOCAL_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS").withZone(DEFAULT_TIME_ZONE);
    private static final HexFormat HEX_FORMAT = HexFormat.of().withUpperCase();

    public static String localDate() {
        return LOCAL_DATE_FORMATTER.format(Instant.now());
    }

    public static String date() {
        return Format.date(Instant.now());
    }

    public static String date(long millis) {
        return Format.date(Instant.ofEpochMilli(millis));
    }

    public static String date(Instant instant) {
        return DATE_FORMATTER.format(instant);
    }

    public static String hexString(byte[] bytes) {
        return HEX_FORMAT.formatHex(bytes);
    }

    public static byte[] parseHexString(String hexString) {
        return HEX_FORMAT.parseHex(hexString);
    }

    public static String time() {
        return Format.time(Instant.now());
    }

    public static String time(long millis) {
        return Format.time(Instant.ofEpochMilli(millis));
    }

    public static String time(Instant instant) {
        return TIME_FORMATTER.format(instant);
    }

    public static String count(long count) {
        return Format.suffixCount(count, COUNT_SIZES, 1000);
    }

    private static String suffixCount(long value, String[] sizes, int stride) {
        double size = value;
        for (String suffix : sizes) {
            if (size < (double)stride) {
                return String.format(Locale.ROOT, "%.2f %s", size, suffix);
            }
            size /= (double)stride;
        }
        return String.format(Locale.ROOT, "%.2f TB", size);
    }

    public static String duration(long durationMillis) {
        return Format.duration(durationMillis, TimeUnit.DAYS, TimeUnit.MILLISECONDS);
    }

    public static String duration(long durationMillis, TimeUnit highestGranularity, TimeUnit lowestGranularity) {
        return Format.duration(durationMillis, highestGranularity, lowestGranularity, Format::shortName);
    }

    public static String duration(long durationMillis, TimeUnit highestGranularity, TimeUnit lowestGranularity, Function<TimeUnit, String> unitFormat) {
        StringBuilder builder = new StringBuilder();
        TimeUnit[] units = TimeUnit.values();
        ArrayUtil.reverse(units);
        boolean use = false;
        for (TimeUnit unit : units) {
            if (unit == highestGranularity) {
                use = true;
            }
            if (!use) continue;
            durationMillis = Format.extractFromDuration(durationMillis, unit, unitFormat, builder);
            if (unit == lowestGranularity) break;
        }
        if (builder.isEmpty()) {
            builder.append('0').append(unitFormat.apply(lowestGranularity));
        }
        return builder.toString();
    }

    private static String shortName(TimeUnit unit) {
        return switch (unit) {
            case TimeUnit.NANOSECONDS -> "ns";
            case TimeUnit.MICROSECONDS -> "\u03bcs";
            case TimeUnit.MILLISECONDS -> "ms";
            default -> unit.name().substring(0, 1).toLowerCase(Locale.ROOT);
        };
    }

    private static long extractFromDuration(long durationMillis, TimeUnit unit, Function<TimeUnit, String> unitFormat, StringBuilder target) {
        long millisPerUnit = unit.toMillis(1L);
        long count = durationMillis / millisPerUnit;
        durationMillis %= millisPerUnit;
        if (count > 0L) {
            target.append(!target.isEmpty() ? " " : "").append(count).append(unitFormat.apply(unit));
        }
        return durationMillis;
    }

    public static String numberToStringWithGroups(long number, char groupSeparatorChar) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setGroupingSeparator(groupSeparatorChar);
        DecimalFormat df = new DecimalFormat();
        df.setDecimalFormatSymbols(symbols);
        df.setGroupingSize(3);
        df.setMaximumFractionDigits(0);
        return df.format(number);
    }

    private Format() {
    }
}

