/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.util.List;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class VectorIndexSearchException
extends Neo4jException {
    private final Status statusCode;

    private VectorIndexSearchException(ErrorGqlStatusObject gqlStatusObject, Status status, String message) {
        super(gqlStatusObject, message);
        this.statusCode = status;
    }

    public static VectorIndexSearchException indexNotFound(String indexName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N69).withParam(GqlParams.StringParam.idxDescrOrName, indexName).build();
        return new VectorIndexSearchException(gql, (Status)Status.Schema.IndexNotFound, gql.getMessage());
    }

    public static VectorIndexSearchException wrongBindingVariableType(String variableName, String expectedType, String actualTypeOfVariable) {
        ErrorGqlStatusObject gqlCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N01).withParam(GqlParams.StringParam.value, new GqlParams.IDENT().process((Object)variableName)).withParam(GqlParams.ListParam.valueTypeList, List.of(expectedType)).withParam(GqlParams.StringParam.valueType, actualTypeOfVariable).build();
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G03).withCause(gqlCause).build();
        return new VectorIndexSearchException(gql, (Status)Status.Statement.TypeError, gqlCause.getMessage());
    }

    public static VectorIndexSearchException propertyNotFound(String propertyName, String indexName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22ND3((String)propertyName, (String)indexName);
        return new VectorIndexSearchException(gql, (Status)Status.Statement.PropertyNotFound, gql.getMessage());
    }

    public Status status() {
        return this.statusCode;
    }
}

