/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.InvalidSpatialArgumentException;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.hashing.HashFunction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.Comparison;
import org.neo4j.values.Equality;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.HashMemoizingScalarValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.NumberValues;
import org.neo4j.values.storable.PointFields;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

public class PointValue
extends HashMemoizingScalarValue
implements Point,
Comparable<PointValue> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(PointValue.class);
    static final long SIZE_2D = SHALLOW_SIZE + HeapEstimator.sizeOf((double[])new double[2]);
    static final long SIZE_3D = SHALLOW_SIZE + HeapEstimator.sizeOf((double[])new double[3]);
    static final PointValue MIN_VALUE_WGS_84 = new PointValue(CoordinateReferenceSystem.WGS_84, -180.0, -90.0);
    static final PointValue MAX_VALUE_WGS_84 = new PointValue(CoordinateReferenceSystem.WGS_84, 180.0, 90.0);
    static final PointValue MIN_VALUE_WGS_84_3D = new PointValue(CoordinateReferenceSystem.WGS_84_3D, -180.0, -90.0, -1.7976931348623157E308);
    static final PointValue MAX_VALUE_WGS_84_3D = new PointValue(CoordinateReferenceSystem.WGS_84_3D, 180.0, 90.0, Double.MAX_VALUE);
    static final PointValue MIN_VALUE_CARTESIAN = new PointValue(CoordinateReferenceSystem.CARTESIAN, -1.7976931348623157E308, -1.7976931348623157E308);
    static final PointValue MAX_VALUE_CARTESIAN = new PointValue(CoordinateReferenceSystem.CARTESIAN, Double.MAX_VALUE, Double.MAX_VALUE);
    static final PointValue MIN_VALUE_CARTESIAN_3D = new PointValue(CoordinateReferenceSystem.CARTESIAN_3D, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    static final PointValue MAX_VALUE_CARTESIAN_3D = new PointValue(CoordinateReferenceSystem.CARTESIAN_3D, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    public static final PointValue MIN_VALUE = Arrays.stream(CoordinateReferenceSystem.values()).map(PointValue::minPointValueOf).min(Values.COMPARATOR).orElseThrow();
    public static final PointValue MAX_VALUE = Arrays.stream(CoordinateReferenceSystem.values()).map(PointValue::maxPointValueOf).max(Values.COMPARATOR).orElseThrow();
    private final CoordinateReferenceSystem crs;
    private final double[] coordinate;

    public static PointValue minPointValueOf(CoordinateReferenceSystem crs) {
        return switch (crs) {
            default -> throw new MatchException(null, null);
            case CoordinateReferenceSystem.WGS_84 -> MIN_VALUE_WGS_84;
            case CoordinateReferenceSystem.WGS_84_3D -> MIN_VALUE_WGS_84_3D;
            case CoordinateReferenceSystem.CARTESIAN -> MIN_VALUE_CARTESIAN;
            case CoordinateReferenceSystem.CARTESIAN_3D -> MIN_VALUE_CARTESIAN_3D;
        };
    }

    public static PointValue maxPointValueOf(CoordinateReferenceSystem crs) {
        return switch (crs) {
            default -> throw new MatchException(null, null);
            case CoordinateReferenceSystem.WGS_84 -> MAX_VALUE_WGS_84;
            case CoordinateReferenceSystem.WGS_84_3D -> MAX_VALUE_WGS_84_3D;
            case CoordinateReferenceSystem.CARTESIAN -> MAX_VALUE_CARTESIAN;
            case CoordinateReferenceSystem.CARTESIAN_3D -> MAX_VALUE_CARTESIAN_3D;
        };
    }

    PointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        this.crs = crs;
        this.coordinate = coordinate;
        for (double c : coordinate) {
            if (Double.isFinite(c)) continue;
            throw InvalidSpatialArgumentException.infiniteCoordinateValue((double[])coordinate);
        }
        if (coordinate.length != crs.getDimension()) {
            throw InvalidSpatialArgumentException.invalidDimension((String)crs.toString(), (int)crs.getDimension(), (double[])coordinate);
        }
        if (crs.isGeographic() && (coordinate.length == 2 || coordinate.length == 3)) {
            double x;
            if (coordinate[1] > 90.0 || coordinate[1] < -90.0) {
                throw InvalidSpatialArgumentException.invalidGeographicCoordinates((double[])coordinate);
            }
            for (x = coordinate[0]; x > 180.0; x -= 360.0) {
            }
            while (x < -180.0) {
                x += 360.0;
            }
            this.coordinate[0] = x;
        }
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writePoint(this.getCoordinateReferenceSystem(), this.coordinate);
    }

    @Override
    public String prettyPrint() {
        PrettyPrinter prettyPrinter = new PrettyPrinter();
        ((Value)this).writeTo(prettyPrinter);
        return prettyPrinter.value();
    }

    @Override
    public String prettify() {
        return this.toString();
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.GEOMETRY;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof PointValue) {
            PointValue pv = (PointValue)other;
            return Arrays.equals(this.coordinate, pv.coordinate) && this.getCoordinateReferenceSystem().equals((Object)pv.getCoordinateReferenceSystem());
        }
        return false;
    }

    public boolean equals(Point other) {
        if (!other.getCRS().getHref().equals(this.getCRS().getHref())) {
            return false;
        }
        double[] otherCoordinates = other.getCoordinate().getCoordinate();
        return Arrays.equals(this.coordinate, otherCoordinates);
    }

    @Override
    public boolean equalTo(Object other) {
        return other != null && (other instanceof Value && this.equals((Value)other) || other instanceof Point && this.equals((Point)other));
    }

    @Override
    public int compareTo(PointValue other) {
        int cmpCRS = Integer.compare(this.crs.getCode(), other.crs.getCode());
        if (cmpCRS != 0) {
            return cmpCRS;
        }
        if (this.coordinate.length > other.coordinate.length) {
            return 1;
        }
        if (this.coordinate.length < other.coordinate.length) {
            return -1;
        }
        for (int i = 0; i < this.coordinate.length; ++i) {
            int cmpVal = Double.compare(this.coordinate[i], other.coordinate[i]);
            if (cmpVal == 0) continue;
            return cmpVal;
        }
        return 0;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareTo((PointValue)otherValue);
    }

    @Override
    public Comparison unsafeTernaryCompareTo(Value otherValue) {
        if (this.ternaryEquals(otherValue) == Equality.TRUE) {
            return Comparison.EQUAL;
        }
        return Comparison.UNDEFINED;
    }

    @Override
    public boolean isIncomparableType() {
        return true;
    }

    public Point asObjectCopy() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public double[] coordinate() {
        return this.coordinate;
    }

    @Override
    protected int computeHashToMemoize() {
        int result = 1;
        result = 31 * result + NumberValues.hash(this.crs.getCode());
        result = 31 * result + NumberValues.hash(this.coordinate);
        return result;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.crs.getCode());
        for (double v : this.coordinate) {
            hash = hashFunction.update(hash, Double.doubleToLongBits(v));
        }
        return hash;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapPoint(this);
    }

    public String toString() {
        String coordString = this.coordinate.length == 2 ? String.format("x: %s, y: %s", this.coordinate[0], this.coordinate[1]) : String.format("x: %s, y: %s, z: %s", this.coordinate[0], this.coordinate[1], this.coordinate[2]);
        return String.format("point({%s, crs: '%s'})", coordString, this.getCoordinateReferenceSystem().getName());
    }

    @Override
    public String getTypeName() {
        return "Point";
    }

    public List<Coordinate> getCoordinates() {
        return Collections.singletonList(new Coordinate(this.coordinate));
    }

    public CRS getCRS() {
        return this.crs;
    }

    public long estimatedHeapUsage() {
        if (this.coordinate.length == 2) {
            return SIZE_2D;
        }
        return SIZE_3D;
    }

    public static PointValue fromMap(MapValue map) {
        PointBuilder fields = new PointBuilder();
        map.foreach((key, value) -> fields.assign(key.toLowerCase(Locale.ROOT), value));
        return PointValue.fromInputFields(fields);
    }

    public static PointValue parse(CharSequence text) {
        return PointValue.parse(text, null);
    }

    public static PointValue parse(CharSequence text, CSVHeaderInformation fieldsFromHeader) {
        PointBuilder fieldsFromData = PointValue.parseHeaderInformation(text);
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof PointBuilder)) {
                throw new IllegalStateException("Wrong header information type: " + String.valueOf(fieldsFromHeader));
            }
            fieldsFromData.mergeWithHeader((PointBuilder)fieldsFromHeader);
        }
        return PointValue.fromInputFields(fieldsFromData);
    }

    public static PointBuilder parseHeaderInformation(CharSequence text) {
        return PointValue.parseHeaderInformation(Value.parseStringMap(text));
    }

    public static PointBuilder parseHeaderInformation(Map<String, String> options) {
        PointBuilder fields = new PointBuilder();
        options.forEach(fields::assign);
        return fields;
    }

    private static CoordinateReferenceSystem findSpecifiedCRS(PointBuilder fields) {
        String crsValue = fields.crs;
        int sridValue = fields.srid;
        if (crsValue != null && sridValue != -1) {
            throw InvalidArgumentException.invalidSpatialValueCombination();
        }
        if (crsValue != null) {
            return CoordinateReferenceSystem.byName(crsValue);
        }
        if (sridValue != -1) {
            return CoordinateReferenceSystem.get(sridValue);
        }
        return null;
    }

    private static PointValue fromInputFields(PointBuilder fields) {
        double[] coordinates;
        CoordinateReferenceSystem crs = PointValue.findSpecifiedCRS(fields);
        if (fields.x != null && fields.y != null) {
            double[] dArray;
            if (fields.z != null) {
                double[] dArray2 = new double[3];
                dArray2[0] = fields.x;
                dArray2[1] = fields.y;
                dArray = dArray2;
                dArray2[2] = fields.z;
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = fields.x;
                dArray = dArray3;
                dArray3[1] = fields.y;
            }
            coordinates = dArray;
            if (crs == null) {
                crs = coordinates.length == 3 ? CoordinateReferenceSystem.CARTESIAN_3D : CoordinateReferenceSystem.CARTESIAN;
            }
        } else if (fields.latitude != null && fields.longitude != null) {
            coordinates = fields.z != null ? new double[]{fields.longitude, fields.latitude, fields.z} : (fields.height != null ? new double[]{fields.longitude, fields.latitude, fields.height} : new double[]{fields.longitude, fields.latitude});
            if (crs == null) {
                CoordinateReferenceSystem coordinateReferenceSystem = crs = coordinates.length == 3 ? CoordinateReferenceSystem.WGS_84_3D : CoordinateReferenceSystem.WGS_84;
            }
            if (!crs.isGeographic()) {
                throw InvalidArgumentException.invalidCRSForGeographic((String)String.valueOf((Object)crs));
            }
        } else {
            if (crs == null) {
                throw InvalidArgumentException.invalidCoordinateNames();
            }
            String mandatoryKeys = switch (crs) {
                default -> throw new MatchException(null, null);
                case CoordinateReferenceSystem.CARTESIAN -> "'x' and 'y'";
                case CoordinateReferenceSystem.CARTESIAN_3D -> "'x', 'y' and 'z'";
                case CoordinateReferenceSystem.WGS_84 -> "'latitude' and 'longitude'";
                case CoordinateReferenceSystem.WGS_84_3D -> "'latitude', 'longitude' and 'height'";
            };
            List<String> mandatoryKeysList = switch (crs) {
                default -> throw new MatchException(null, null);
                case CoordinateReferenceSystem.CARTESIAN -> List.of("x", "y");
                case CoordinateReferenceSystem.CARTESIAN_3D -> List.of("x", "y", "z");
                case CoordinateReferenceSystem.WGS_84 -> List.of("latitude", "longitude");
                case CoordinateReferenceSystem.WGS_84_3D -> List.of("latitude", "longitude", "height");
            };
            throw InvalidArgumentException.incompleteSpatialValue((String)String.valueOf((Object)crs), (String)mandatoryKeys, mandatoryKeysList);
        }
        if (crs.getDimension() != coordinates.length) {
            throw InvalidArgumentException.pointWithWrongDimensions((int)crs.getDimension(), (int)coordinates.length);
        }
        return Values.pointValue(crs, coordinates);
    }

    public Value get(String fieldName) {
        return PointFields.fromName(fieldName).get(this);
    }

    DoubleValue getNthCoordinate(int n, String fieldName, boolean onlyGeographic) {
        if (onlyGeographic && !this.getCoordinateReferenceSystem().isGeographic()) {
            throw InvalidArgumentException.fieldNotAvailableOnPoint((String)fieldName, (String)String.valueOf(this), (Boolean)true);
        }
        if (n >= this.coordinate().length) {
            throw InvalidArgumentException.fieldNotAvailableOnPoint((String)fieldName, (String)String.valueOf(this), (Boolean)false);
        }
        return Values.doubleValue(this.coordinate[n]);
    }

    private static class PointBuilder
    implements CSVHeaderInformation {
        private String crs;
        private Double x;
        private Double y;
        private Double z;
        private Double longitude;
        private Double latitude;
        private Double height;
        private int srid = -1;

        private PointBuilder() {
        }

        @Override
        public void assign(String key, Object value) {
            switch (key.toLowerCase(Locale.ROOT)) {
                case "crs": {
                    PointBuilder.checkUnassigned(this.crs, key);
                    PointBuilder.assignTextValue(key, value, str -> {
                        this.crs = Value.QUOTES_PATTERN.matcher((CharSequence)str).replaceAll("");
                    });
                    break;
                }
                case "x": {
                    PointBuilder.checkUnassigned(this.x, key);
                    PointBuilder.assignFloatingPoint(key, value, i -> {
                        this.x = i;
                    });
                    break;
                }
                case "y": {
                    PointBuilder.checkUnassigned(this.y, key);
                    PointBuilder.assignFloatingPoint(key, value, i -> {
                        this.y = i;
                    });
                    break;
                }
                case "z": {
                    PointBuilder.checkUnassigned(this.z, key);
                    PointBuilder.assignFloatingPoint(key, value, i -> {
                        this.z = i;
                    });
                    break;
                }
                case "longitude": {
                    PointBuilder.checkUnassigned(this.longitude, key);
                    PointBuilder.assignFloatingPoint(key, value, i -> {
                        this.longitude = i;
                    });
                    break;
                }
                case "latitude": {
                    PointBuilder.checkUnassigned(this.latitude, key);
                    PointBuilder.assignFloatingPoint(key, value, i -> {
                        this.latitude = i;
                    });
                    break;
                }
                case "height": {
                    PointBuilder.checkUnassigned(this.height, key);
                    PointBuilder.assignFloatingPoint(key, value, i -> {
                        this.height = i;
                    });
                    break;
                }
                case "srid": {
                    if (this.srid != -1) {
                        throw InvalidArgumentException.duplicateFieldNotAllowed((String)key);
                    }
                    PointBuilder.assignIntegral(key, value, i -> {
                        this.srid = i;
                    });
                    break;
                }
            }
        }

        void mergeWithHeader(PointBuilder header) {
            this.crs = this.crs == null ? header.crs : this.crs;
            this.x = this.x == null ? header.x : this.x;
            this.y = this.y == null ? header.y : this.y;
            this.z = this.z == null ? header.z : this.z;
            this.longitude = this.longitude == null ? header.longitude : this.longitude;
            this.latitude = this.latitude == null ? header.latitude : this.latitude;
            this.height = this.height == null ? header.height : this.height;
            this.srid = this.srid == -1 ? header.srid : this.srid;
        }

        private static void assignTextValue(String key, Object value, Consumer<String> assigner) {
            if (value instanceof String) {
                assigner.accept((String)value);
            } else if (value instanceof TextValue) {
                assigner.accept(((TextValue)value).stringValue());
            } else {
                String string;
                if (value instanceof Value) {
                    Value v = (Value)value;
                    string = v.prettyPrint();
                } else {
                    string = String.valueOf(value);
                }
                String prettyVal = string;
                throw InvalidArgumentException.cannotAssignPointField((String)String.valueOf(value), (String)key, (String)prettyVal, List.of("STRING"));
            }
        }

        private static void assignFloatingPoint(String key, Object value, Consumer<Double> assigner) {
            if (value instanceof String) {
                String s = (String)value;
                assigner.accept(PointBuilder.assertConvertible(() -> Double.parseDouble(s), s));
            } else if (value instanceof IntegralValue) {
                assigner.accept(((IntegralValue)value).doubleValue());
            } else if (value instanceof FloatingPointValue) {
                assigner.accept(((FloatingPointValue)value).doubleValue());
            } else {
                String string;
                if (value instanceof Value) {
                    Value v = (Value)value;
                    string = v.prettyPrint();
                } else {
                    string = String.valueOf(value);
                }
                String prettyVal = string;
                throw InvalidArgumentException.cannotAssignPointField((String)String.valueOf(value), (String)key, (String)prettyVal, List.of("FLOAT", "INTEGER"));
            }
        }

        private static void assignIntegral(String key, Object value, Consumer<Integer> assigner) {
            if (value instanceof String) {
                String s = (String)value;
                assigner.accept(PointBuilder.assertConvertible(() -> Integer.parseInt(s), s));
            } else if (value instanceof IntegralValue) {
                assigner.accept((int)((IntegralValue)value).longValue());
            } else {
                String string;
                if (value instanceof Value) {
                    Value v = (Value)value;
                    string = v.prettyPrint();
                } else {
                    string = String.valueOf(value);
                }
                String prettyVal = string;
                throw InvalidArgumentException.cannotAssignPointField((String)String.valueOf(value), (String)key, (String)prettyVal, List.of("INTEGER"));
            }
        }

        private static <T extends Number> T assertConvertible(Supplier<T> func, String input) {
            try {
                return (T)((Number)func.get());
            }
            catch (NumberFormatException e) {
                throw InvalidArgumentException.failedConvertFunction((String)input, (Throwable)e);
            }
        }

        private static void checkUnassigned(Object key, String fieldName) {
            if (key != null) {
                throw InvalidArgumentException.duplicateFieldNotAllowed((String)fieldName);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PointBuilder that = (PointBuilder)o;
            return this.srid == that.srid && Objects.equals(this.crs, that.crs) && Objects.equals(this.x, that.x) && Objects.equals(this.y, that.y) && Objects.equals(this.z, that.z) && Objects.equals(this.longitude, that.longitude) && Objects.equals(this.latitude, that.latitude) && Objects.equals(this.height, that.height);
        }

        public int hashCode() {
            return Objects.hash(this.crs, this.x, this.y, this.z, this.longitude, this.latitude, this.height, this.srid);
        }
    }
}

