/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.OffsetTime;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public class TimeArray
extends TemporalArray<OffsetTime> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TimeArray.class);
    private final OffsetTime[] value;

    TimeArray(OffsetTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected OffsetTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapTimeArray(this);
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(OffsetTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        TimeArray.writeTo(writer, ValueWriter.ArrayType.ZONED_TIME, this.value);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.ZONED_TIME_ARRAY;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((TimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "TimeArray";
    }

    @Override
    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray((long)HeapEstimator.OFFSET_TIME_SIZE, (int)this.value.length);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof TimeValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        OffsetTime[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((TimeValue)added).temporal();
        return new TimeArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        OffsetTime[] newArray = new OffsetTime[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((TimeValue)prepended).temporal();
        return new TimeArray(newArray);
    }
}

