/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.VectorValue;

public class ValueTypeNames {
    public static String nameOfType(Value value) {
        return ValueTypeNames.ofRepresentation(value.valueRepresentation(), value);
    }

    public static String ofRepresentation(ValueRepresentation valueRepresentation, Value value) {
        return switch (valueRepresentation) {
            default -> throw new MatchException(null, null);
            case ValueRepresentation.UNKNOWN -> "UNKNOWN";
            case ValueRepresentation.ANYTHING -> "ANY";
            case ValueRepresentation.GEOMETRY_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.GEOMETRY);
            case ValueRepresentation.ZONED_DATE_TIME_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.ZONED_DATE_TIME);
            case ValueRepresentation.LOCAL_DATE_TIME_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.LOCAL_DATE_TIME);
            case ValueRepresentation.DATE_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.DATE);
            case ValueRepresentation.ZONED_TIME_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.ZONED_TIME);
            case ValueRepresentation.LOCAL_TIME_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.LOCAL_TIME);
            case ValueRepresentation.DURATION_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.DURATION);
            case ValueRepresentation.TEXT_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.UTF16_TEXT);
            case ValueRepresentation.BOOLEAN_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.BOOLEAN);
            case ValueRepresentation.INT64_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.INT64);
            case ValueRepresentation.INT32_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.INT32);
            case ValueRepresentation.INT16_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.INT16);
            case ValueRepresentation.INT8_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.INT8);
            case ValueRepresentation.FLOAT64_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.FLOAT64);
            case ValueRepresentation.FLOAT32_ARRAY -> ValueTypeNames.listOf(ValueRepresentation.FLOAT32);
            case ValueRepresentation.GEOMETRY -> "POINT";
            case ValueRepresentation.ZONED_DATE_TIME -> "ZONED DATETIME";
            case ValueRepresentation.LOCAL_DATE_TIME -> "LOCAL DATETIME";
            case ValueRepresentation.DATE -> "DATE";
            case ValueRepresentation.ZONED_TIME -> "ZONED TIME";
            case ValueRepresentation.LOCAL_TIME -> "LOCAL TIME";
            case ValueRepresentation.DURATION -> "DURATION";
            case ValueRepresentation.UTF16_TEXT -> "STRING";
            case ValueRepresentation.UTF8_TEXT -> "STRING";
            case ValueRepresentation.BOOLEAN -> "BOOLEAN";
            case ValueRepresentation.INT64 -> "INTEGER";
            case ValueRepresentation.INT32 -> "INTEGER";
            case ValueRepresentation.INT16 -> "INTEGER";
            case ValueRepresentation.INT8 -> "INTEGER";
            case ValueRepresentation.FLOAT64 -> "FLOAT";
            case ValueRepresentation.FLOAT32 -> "FLOAT";
            case ValueRepresentation.INT8_VECTOR -> ValueTypeNames.vectorOf("INTEGER8", value);
            case ValueRepresentation.INT16_VECTOR -> ValueTypeNames.vectorOf("INTEGER16", value);
            case ValueRepresentation.INT32_VECTOR -> ValueTypeNames.vectorOf("INTEGER32", value);
            case ValueRepresentation.INT64_VECTOR -> ValueTypeNames.vectorOf("INTEGER", value);
            case ValueRepresentation.FLOAT32_VECTOR -> ValueTypeNames.vectorOf("FLOAT32", value);
            case ValueRepresentation.FLOAT64_VECTOR -> ValueTypeNames.vectorOf("FLOAT", value);
            case ValueRepresentation.NO_VALUE -> "NULL";
        };
    }

    private static String listOf(ValueRepresentation memberRepresentation) {
        return String.format("LIST<%s>", ValueTypeNames.ofRepresentation(memberRepresentation, null));
    }

    private static String vectorOf(String memberTypeName, Value value) {
        String dimensions = "";
        if (value instanceof VectorValue) {
            VectorValue vector = (VectorValue)value;
            dimensions = String.valueOf(vector.dimensions());
        }
        return String.format("VECTOR<%s>(%s)", memberTypeName, dimensions);
    }
}

