/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.List;
import org.github.jamm.Unmetered;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.HeapEstimatorCache;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.virtual.ListValue;

public class HeapTrackingListValueBuilder
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingListValueBuilder.class);
    private static final long HEAP_SIZE_ALLOCATION_THRESHOLD = 4096L;
    private final HeapTrackingArrayList<AnyValue> values;
    private final MemoryTracker scopedMemoryTracker;
    private final HeapEstimatorCache heapEstimatorCache;
    @Unmetered
    private ValueRepresentation representation;
    private long unAllocatedHeapSize;

    public static HeapTrackingListValueBuilder newHeapTrackingListBuilder(MemoryTracker memoryTracker) {
        return new HeapTrackingListValueBuilder(memoryTracker, 16);
    }

    public static HeapTrackingListValueBuilder newHeapTrackingListBuilder(MemoryTracker memoryTracker, int initialCapacity) {
        return new HeapTrackingListValueBuilder(memoryTracker, initialCapacity);
    }

    HeapTrackingListValueBuilder(MemoryTracker memoryTracker, int initialCapacity) {
        this.scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
        this.scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
        this.values = HeapTrackingArrayList.newArrayList((int)initialCapacity, (MemoryTracker)this.scopedMemoryTracker);
        this.representation = ValueRepresentation.ANYTHING;
        this.heapEstimatorCache = memoryTracker.getScopedHeapEstimatorCache();
    }

    public void addAll(Iterable<AnyValue> values) {
        for (AnyValue value : values) {
            this.add(value);
        }
    }

    public void add(AnyValue value) {
        this.unAllocatedHeapSize += value.estimatedHeapUsage(this.heapEstimatorCache);
        if (this.unAllocatedHeapSize >= 4096L) {
            this.scopedMemoryTracker.allocateHeap(this.unAllocatedHeapSize);
            this.unAllocatedHeapSize = 0L;
        }
        this.representation = this.representation.coerce(value.valueRepresentation());
        this.values.add((Object)value);
    }

    public ListValue build() {
        this.scopedMemoryTracker.allocateHeap(this.unAllocatedHeapSize);
        this.unAllocatedHeapSize = 0L;
        this.heapEstimatorCache.fullReset();
        return new ListValue.JavaListListValue((List<AnyValue>)this.values, this.payloadSize(), this.representation);
    }

    public ListValue buildAndClose() {
        ListValue value = this.build();
        this.close();
        return value;
    }

    private long payloadSize() {
        return Math.max(this.unAllocatedHeapSize + this.scopedMemoryTracker.estimatedHeapMemory() - SHALLOW_SIZE, 0L);
    }

    @VisibleForTesting
    public long getUnAllocatedHeapSize() {
        return this.unAllocatedHeapSize;
    }

    @Override
    public void close() {
        this.scopedMemoryTracker.close();
    }
}

