/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import java.util.Iterator;
import java.util.Objects;
import org.github.jamm.Unmetered;
import org.neo4j.collection.trackable.HeapTrackingOrderedAppendSet;
import org.neo4j.collection.trackable.OrderedAppendSet;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.AnyValue;
import org.neo4j.values.Equality;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;

public final class SetListValue
extends ListValue {
    private static final long SET_LIST_VALUE_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(SetListValue.class);
    @Unmetered
    private final ValueRepresentation itemRepresentation;
    private final OrderedAppendSet<AnyValue> set;
    private final long payload;

    public static HeapTrackingBuilder heapTrackingBuilder(MemoryTracker memoryTracker) {
        return new HeapTrackingBuilder(memoryTracker);
    }

    SetListValue(OrderedAppendSet<AnyValue> set, long payload, ValueRepresentation itemRepresentation) {
        this.itemRepresentation = itemRepresentation;
        this.set = set;
        this.payload = payload;
    }

    @Override
    public ValueRepresentation itemValueRepresentation() {
        return this.itemRepresentation;
    }

    public long estimatedHeapUsage() {
        return SET_LIST_VALUE_SHALLOW_SIZE + this.payload;
    }

    @Override
    public long actualSize() {
        return this.set.size();
    }

    @Override
    public AnyValue value(long offset) {
        Objects.checkIndex(offset, (long)this.intSize());
        return (AnyValue)this.set.get((int)offset);
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public AnyValue head() {
        if (this.set.isEmpty()) {
            return Values.NO_VALUE;
        }
        return (AnyValue)this.set.getFirst();
    }

    @Override
    public ListValue reverse() {
        return new SetListValue((OrderedAppendSet<AnyValue>)this.set.reversedOrderedAppendSet(), this.payload, this.itemRepresentation);
    }

    @Override
    public AnyValue last() {
        if (this.set.isEmpty()) {
            return Values.NO_VALUE;
        }
        return (AnyValue)this.set.getLast();
    }

    @Override
    public Value ternaryContains(AnyValue value) {
        if (value instanceof SequenceValue || value instanceof MapValue) {
            return this.ternaryContainsMayHaveNull(value);
        }
        return this.ternaryContainsSafe(value);
    }

    private Value ternaryContainsSafe(AnyValue value) {
        return value != Values.NO_VALUE ? Values.booleanValue(this.set.contains((Object)value)) : Values.NO_VALUE;
    }

    private Value ternaryContainsMayHaveNull(AnyValue value) {
        if (this.set.contains((Object)value)) {
            return value.ternaryEquals(value) == Equality.TRUE ? Values.TRUE : Values.NO_VALUE;
        }
        return super.ternaryContains(value);
    }

    @Override
    public ListValue distinct() {
        return this;
    }

    @Override
    protected long compactInto(AnyValue[] array, int fromInclusive) {
        int i = fromInclusive;
        Iterator<AnyValue> iterator = this.iterator();
        while (iterator.hasNext()) {
            AnyValue x;
            array[i] = x = iterator.next();
            ++i;
        }
        return this.payload;
    }

    @Override
    public Iterator<AnyValue> iterator() {
        return this.set.iterator();
    }

    @Override
    public SequenceValue.IterationPreference iterationPreference() {
        return SequenceValue.IterationPreference.ITERATION;
    }

    public static final class HeapTrackingBuilder
    implements AutoCloseable {
        private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingBuilder.class);
        @Unmetered
        private ValueRepresentation valueRepresentation;
        private long unAllocatedHeapSize;
        private final HeapTrackingOrderedAppendSet<AnyValue> set;
        private static final long HEAP_SIZE_ALLOCATION_THRESHOLD = 4096L;
        private final MemoryTracker scopedMemoryTracker;

        private HeapTrackingBuilder(MemoryTracker memoryTracker) {
            this.scopedMemoryTracker = memoryTracker.getScopedMemoryTracker();
            this.scopedMemoryTracker.allocateHeap(SHALLOW_SIZE + HeapEstimator.SCOPED_MEMORY_TRACKER_SHALLOW_SIZE);
            this.set = HeapTrackingOrderedAppendSet.createOrderedSet((MemoryTracker)this.scopedMemoryTracker);
            this.valueRepresentation = ValueRepresentation.ANYTHING;
        }

        public void addAll(Iterable<? extends AnyValue> values) {
            for (AnyValue anyValue : values) {
                this.add(anyValue);
            }
        }

        public void add(AnyValue value) {
            assert (value != Values.NO_VALUE);
            if (this.set.add((Object)value)) {
                this.unAllocatedHeapSize += value.estimatedHeapUsage();
                if (this.unAllocatedHeapSize >= 4096L) {
                    this.scopedMemoryTracker.allocateHeap(this.unAllocatedHeapSize);
                    this.unAllocatedHeapSize = 0L;
                }
                this.valueRepresentation = this.valueRepresentation.coerce(value.valueRepresentation());
            }
        }

        public SetListValue build() {
            this.scopedMemoryTracker.allocateHeap(this.unAllocatedHeapSize);
            this.unAllocatedHeapSize = 0L;
            return new SetListValue((OrderedAppendSet<AnyValue>)this.set, this.payloadSize(), this.valueRepresentation);
        }

        public SetListValue buildAndClose() {
            SetListValue value = this.build();
            this.close();
            return value;
        }

        @Override
        public void close() {
            this.scopedMemoryTracker.close();
        }

        private long payloadSize() {
            return Math.max(this.unAllocatedHeapSize + this.scopedMemoryTracker.estimatedHeapMemory() - SHALLOW_SIZE, 0L);
        }
    }
}

