/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.List;

public class Scheme {
    public static final String BOLT_URI_SCHEME = "bolt";
    public static final String BOLT_HIGH_TRUST_URI_SCHEME = "bolt+s";
    public static final String BOLT_LOW_TRUST_URI_SCHEME = "bolt+ssc";
    public static final String NEO4J_URI_SCHEME = "neo4j";
    public static final String NEO4J_HIGH_TRUST_URI_SCHEME = "neo4j+s";
    public static final String NEO4J_LOW_TRUST_URI_SCHEME = "neo4j+ssc";

    public static boolean isHighTrustScheme(String scheme) {
        return scheme.equals(BOLT_HIGH_TRUST_URI_SCHEME) || scheme.equals(NEO4J_HIGH_TRUST_URI_SCHEME);
    }

    public static boolean isLowTrustScheme(String scheme) {
        return scheme.equals(BOLT_LOW_TRUST_URI_SCHEME) || scheme.equals(NEO4J_LOW_TRUST_URI_SCHEME);
    }

    public static boolean isSecurityScheme(String scheme) {
        return List.of(BOLT_LOW_TRUST_URI_SCHEME, NEO4J_LOW_TRUST_URI_SCHEME, BOLT_HIGH_TRUST_URI_SCHEME, NEO4J_HIGH_TRUST_URI_SCHEME).contains(scheme);
    }

    public static boolean isRoutingScheme(String scheme) {
        return List.of(NEO4J_LOW_TRUST_URI_SCHEME, NEO4J_HIGH_TRUST_URI_SCHEME, NEO4J_URI_SCHEME).contains(scheme);
    }
}

