/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Arrays;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ValueAdapter;

public class BytesValue
extends ValueAdapter {
    private final byte[] val;

    public BytesValue(byte[] val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct BytesValue from null");
        }
        this.val = val;
    }

    @Override
    public boolean isEmpty() {
        return this.val.length == 0;
    }

    @Override
    public int size() {
        return this.val.length;
    }

    public byte[] asObject() {
        return this.val;
    }

    @Override
    public byte[] asByteArray() {
        return this.val;
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(byte[].class)) {
            return targetClass.cast(this.asByteArray());
        }
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.BYTES();
    }

    public Type boltValueType() {
        return Type.BYTES;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BytesValue values = (BytesValue)o;
        return Arrays.equals(this.val, values.val);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.val);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("#");
        for (byte b : this.val) {
            if (b < 16) {
                s.append('0');
            }
            s.append(Integer.toHexString(b));
        }
        return s.toString();
    }
}

