/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.api;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.dbms.api.DatabaseAliasExistsException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;

public class DatabaseAliasExistsHelper {
    public static DatabaseAliasExistsException cannotDropDatabaseWithAlias(String database, List<String> aliases) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N82).withParam(GqlParams.StringParam.db, database).withParam(GqlParams.ListParam.aliasList, aliases.stream().sorted().toList()).build();
        String aliasesJoined = aliases.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
        String legacyMessage = "Failed to delete the specified database '%s': Database has one or more aliases. Drop the aliases: [%s] before dropping the database.".formatted(database, aliasesJoined);
        return new DatabaseAliasExistsException(gql, legacyMessage);
    }

    public static DatabaseAliasExistsException cannotDropCompositeWithAlias(String database, List<String> aliases) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N82).withParam(GqlParams.StringParam.db, database).withParam(GqlParams.ListParam.aliasList, aliases.stream().sorted().toList()).build();
        String aliasesJoined = aliases.stream().sorted().collect(Collectors.joining("', '", "'", "'"));
        String legacyMessage = "Failed to delete the specified composite database '%s': Composite database has one or more constituent aliases. Drop the aliases: [%s] before dropping the database.".formatted(database, aliasesJoined);
        return new DatabaseAliasExistsException(gql, legacyMessage);
    }
}

