/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gqlstatus;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlHelper;

@PublicApi
public abstract class GqlRuntimeException
extends RuntimeException
implements ErrorGqlStatusObject {
    private final ErrorGqlStatusObject innerGqlStatusObject;
    private final String oldMessage;

    @Deprecated(forRemoval=true, since="5.26")
    protected GqlRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.innerGqlStatusObject = null;
        this.oldMessage = message;
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, message), cause);
        this.innerGqlStatusObject = GqlHelper.getInnerGqlStatusObject(gqlStatusObject, cause);
        this.oldMessage = message;
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, String message) {
        this(gqlStatusObject, message, null);
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, Throwable cause) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, cause.getMessage()), cause);
        this.innerGqlStatusObject = GqlHelper.getInnerGqlStatusObject(gqlStatusObject, cause);
        this.oldMessage = ErrorMessageHolder.getOldCauseMessage(cause);
    }

    protected GqlRuntimeException(ErrorGqlStatusObject gqlStatusObject, String message, boolean suppression, boolean stacktrace) {
        super(ErrorMessageHolder.getMessage(gqlStatusObject, message), null, suppression, stacktrace);
        this.innerGqlStatusObject = gqlStatusObject;
        this.oldMessage = message;
    }

    @Override
    public String legacyMessage() {
        return this.oldMessage;
    }

    @Override
    public ErrorGqlStatusObject gqlStatusObject() {
        return this.innerGqlStatusObject;
    }
}

