/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.AuthorizationStateListener;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.messaging.BoltPatchesListener;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.util.ServerVersion;

public final class ChannelAttributes {
    private static final AttributeKey<String> CONNECTION_ID = AttributeKey.newInstance("connectionId");
    private static final AttributeKey<String> POOL_ID = AttributeKey.newInstance("poolId");
    private static final AttributeKey<BoltProtocolVersion> PROTOCOL_VERSION = AttributeKey.newInstance("protocolVersion");
    private static final AttributeKey<String> SERVER_AGENT = AttributeKey.newInstance("serverAgent");
    private static final AttributeKey<BoltServerAddress> ADDRESS = AttributeKey.newInstance("serverAddress");
    private static final AttributeKey<ServerVersion> SERVER_VERSION = AttributeKey.newInstance("serverVersion");
    private static final AttributeKey<Long> CREATION_TIMESTAMP = AttributeKey.newInstance("creationTimestamp");
    private static final AttributeKey<Long> LAST_USED_TIMESTAMP = AttributeKey.newInstance("lastUsedTimestamp");
    private static final AttributeKey<InboundMessageDispatcher> MESSAGE_DISPATCHER = AttributeKey.newInstance("messageDispatcher");
    private static final AttributeKey<String> TERMINATION_REASON = AttributeKey.newInstance("terminationReason");
    private static final AttributeKey<AuthorizationStateListener> AUTHORIZATION_STATE_LISTENER = AttributeKey.newInstance("authorizationStateListener");
    private static final AttributeKey<Set<BoltPatchesListener>> BOLT_PATCHES_LISTENERS = AttributeKey.newInstance("boltPatchesListeners");
    private static final AttributeKey<Long> CONNECTION_READ_TIMEOUT = AttributeKey.newInstance("connectionReadTimeout");

    private ChannelAttributes() {
    }

    public static String connectionId(Channel channel) {
        return ChannelAttributes.get(channel, CONNECTION_ID);
    }

    public static void setConnectionId(Channel channel, String id) {
        ChannelAttributes.setOnce(channel, CONNECTION_ID, id);
    }

    public static String poolId(Channel channel) {
        return ChannelAttributes.get(channel, POOL_ID);
    }

    public static void setPoolId(Channel channel, String id) {
        ChannelAttributes.setOnce(channel, POOL_ID, id);
    }

    public static BoltProtocolVersion protocolVersion(Channel channel) {
        return ChannelAttributes.get(channel, PROTOCOL_VERSION);
    }

    public static void setProtocolVersion(Channel channel, BoltProtocolVersion version) {
        ChannelAttributes.setOnce(channel, PROTOCOL_VERSION, version);
    }

    public static void setServerAgent(Channel channel, String serverAgent) {
        ChannelAttributes.setOnce(channel, SERVER_AGENT, serverAgent);
    }

    public static String serverAgent(Channel channel) {
        return ChannelAttributes.get(channel, SERVER_AGENT);
    }

    public static BoltServerAddress serverAddress(Channel channel) {
        return ChannelAttributes.get(channel, ADDRESS);
    }

    public static void setServerAddress(Channel channel, BoltServerAddress address) {
        ChannelAttributes.setOnce(channel, ADDRESS, address);
    }

    public static ServerVersion serverVersion(Channel channel) {
        return ChannelAttributes.get(channel, SERVER_VERSION);
    }

    public static void setServerVersion(Channel channel, ServerVersion version) {
        ChannelAttributes.setOnce(channel, SERVER_VERSION, version);
    }

    public static long creationTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, CREATION_TIMESTAMP);
    }

    public static void setCreationTimestamp(Channel channel, long creationTimestamp) {
        ChannelAttributes.setOnce(channel, CREATION_TIMESTAMP, creationTimestamp);
    }

    public static Long lastUsedTimestamp(Channel channel) {
        return ChannelAttributes.get(channel, LAST_USED_TIMESTAMP);
    }

    public static void setLastUsedTimestamp(Channel channel, long lastUsedTimestamp) {
        ChannelAttributes.set(channel, LAST_USED_TIMESTAMP, lastUsedTimestamp);
    }

    public static InboundMessageDispatcher messageDispatcher(Channel channel) {
        return ChannelAttributes.get(channel, MESSAGE_DISPATCHER);
    }

    public static void setMessageDispatcher(Channel channel, InboundMessageDispatcher messageDispatcher) {
        ChannelAttributes.setOnce(channel, MESSAGE_DISPATCHER, messageDispatcher);
    }

    public static String terminationReason(Channel channel) {
        return ChannelAttributes.get(channel, TERMINATION_REASON);
    }

    public static void setTerminationReason(Channel channel, String reason) {
        ChannelAttributes.setOnce(channel, TERMINATION_REASON, reason);
    }

    public static AuthorizationStateListener authorizationStateListener(Channel channel) {
        return ChannelAttributes.get(channel, AUTHORIZATION_STATE_LISTENER);
    }

    public static void setAuthorizationStateListener(Channel channel, AuthorizationStateListener authorizationStateListener) {
        ChannelAttributes.set(channel, AUTHORIZATION_STATE_LISTENER, authorizationStateListener);
    }

    public static Optional<Long> connectionReadTimeout(Channel channel) {
        return Optional.ofNullable(ChannelAttributes.get(channel, CONNECTION_READ_TIMEOUT));
    }

    public static void setConnectionReadTimeout(Channel channel, Long connectionReadTimeout) {
        ChannelAttributes.setOnce(channel, CONNECTION_READ_TIMEOUT, connectionReadTimeout);
    }

    public static void addBoltPatchesListener(Channel channel, BoltPatchesListener listener) {
        Set<BoltPatchesListener> boltPatchesListeners = ChannelAttributes.get(channel, BOLT_PATCHES_LISTENERS);
        if (boltPatchesListeners == null) {
            boltPatchesListeners = new HashSet<BoltPatchesListener>();
            ChannelAttributes.setOnce(channel, BOLT_PATCHES_LISTENERS, boltPatchesListeners);
        }
        boltPatchesListeners.add(listener);
    }

    public static Set<BoltPatchesListener> boltPatchesListeners(Channel channel) {
        Set<BoltPatchesListener> boltPatchesListeners = ChannelAttributes.get(channel, BOLT_PATCHES_LISTENERS);
        return boltPatchesListeners != null ? boltPatchesListeners : Collections.emptySet();
    }

    private static <T> T get(Channel channel, AttributeKey<T> key) {
        return channel.attr(key).get();
    }

    private static <T> void set(Channel channel, AttributeKey<T> key, T value) {
        channel.attr(key).set(value);
    }

    private static <T> void setOnce(Channel channel, AttributeKey<T> key, T value) {
        T existingValue = channel.attr(key).setIfAbsent(value);
        if (existingValue != null) {
            throw new IllegalStateException("Unable to set " + key.name() + " because it is already set to " + existingValue);
        }
    }
}

