/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.LocalDateTime;
import java.util.Arrays;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;

public class LocalDateTimeArray
extends TemporalArray<LocalDateTime> {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LocalDateTimeArray.class);
    private final LocalDateTime[] value;

    LocalDateTimeArray(LocalDateTime[] value) {
        assert (value != null);
        this.value = value;
    }

    protected LocalDateTime[] value() {
        return this.value;
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapLocalDateTimeArray(this);
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(LocalDateTime[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        LocalDateTimeArray.writeTo(writer, ValueWriter.ArrayType.LOCAL_DATE_TIME, this.value);
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.LOCAL_DATE_TIME_ARRAY;
    }

    @Override
    protected int unsafeCompareTo(Value otherValue) {
        return this.compareToNonPrimitiveArray((LocalDateTimeArray)otherValue);
    }

    @Override
    public String getTypeName() {
        return "LocalDateTimeArray";
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE + HeapEstimator.sizeOfObjectArray((long)HeapEstimator.LOCAL_DATE_TIME_SIZE, (int)this.value.length);
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof LocalDateTimeValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        LocalDateTime[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((LocalDateTimeValue)added).temporal();
        return new LocalDateTimeArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        LocalDateTime[] newArray = new LocalDateTime[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((LocalDateTimeValue)prepended).temporal();
        return new LocalDateTimeArray(newArray);
    }
}

