/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.literal.interpreter;

import java.time.Clock;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.ast.factory.ASTFactory;
import org.neo4j.cypher.internal.ast.factory.AccessType;
import org.neo4j.cypher.internal.ast.factory.ActionType;
import org.neo4j.cypher.internal.ast.factory.CallInTxsOnErrorBehaviourType;
import org.neo4j.cypher.internal.ast.factory.ConstraintType;
import org.neo4j.cypher.internal.ast.factory.ConstraintVersion;
import org.neo4j.cypher.internal.ast.factory.CreateIndexTypes;
import org.neo4j.cypher.internal.ast.factory.HintIndexType;
import org.neo4j.cypher.internal.ast.factory.ParameterType;
import org.neo4j.cypher.internal.ast.factory.ParserCypherTypeName;
import org.neo4j.cypher.internal.ast.factory.ScopeType;
import org.neo4j.cypher.internal.ast.factory.ShowCommandFilterTypes;
import org.neo4j.cypher.internal.ast.factory.SimpleEither;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public class LiteralInterpreter
implements ASTFactory<ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, Object, ASTFactory.NULL, Object, Object, Object, Object, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL> {
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    public static final String LONG_MIN_VALUE_DECIMAL_STRING = Long.toString(Long.MIN_VALUE).substring(1);
    public static final String LONG_MIN_VALUE_HEXADECIMAL_STRING = "0x" + Long.toString(Long.MIN_VALUE, 16).substring(1);
    public static final String LONG_MIN_VALUE_OCTAL_STRING_OLD_SYNTAX = "0" + Long.toString(Long.MIN_VALUE, 8).substring(1);
    public static final String LONG_MIN_VALUE_OCTAL_STRING = "0o" + Long.toString(Long.MIN_VALUE, 8).substring(1);

    public ASTFactory.NULL newSingleQuery(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("newSingleQuery is not a literal");
    }

    public ASTFactory.NULL newSingleQuery(List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("newSingleQuery is not a literal");
    }

    public ASTFactory.NULL newUnion(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean all) {
        throw new UnsupportedOperationException("newUnion is not a literal");
    }

    public ASTFactory.NULL directUseClause(ASTFactory.NULL p, ASTFactory.NULL o) {
        throw new UnsupportedOperationException("directUseClause is not a literal");
    }

    public ASTFactory.NULL functionUseClause(ASTFactory.NULL p, Object function) {
        throw new UnsupportedOperationException("directUseClause is not a literal");
    }

    public ASTFactory.NULL newReturnClause(ASTFactory.NULL p, boolean distinct, ASTFactory.NULL nulls, List<ASTFactory.NULL> order, ASTFactory.NULL orderPos, Object skip, ASTFactory.NULL skipPosition, Object limit, ASTFactory.NULL limitPosition) {
        throw new UnsupportedOperationException("newReturnClause is not a literal");
    }

    public ASTFactory.NULL newReturnItems(ASTFactory.NULL p, boolean returnAll, List<ASTFactory.NULL> returnItems) {
        throw new UnsupportedOperationException("newReturnItems is not a literal");
    }

    public ASTFactory.NULL newReturnItem(ASTFactory.NULL p, Object e, Object v) {
        throw new UnsupportedOperationException("newReturnItem is not a literal");
    }

    public ASTFactory.NULL newReturnItem(ASTFactory.NULL p, Object e, int eStartOffset, int eEndOffset) {
        throw new UnsupportedOperationException("newReturnItem is not a literal");
    }

    public ASTFactory.NULL orderDesc(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("orderDesc is not a literal");
    }

    public ASTFactory.NULL orderAsc(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("orderAsc is not a literal");
    }

    public ASTFactory.NULL whereClause(ASTFactory.NULL p, Object where) {
        throw new UnsupportedOperationException("withClause is not a literal");
    }

    public ASTFactory.NULL withClause(ASTFactory.NULL p, ASTFactory.NULL aNull, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("withClause is not a literal");
    }

    public ASTFactory.NULL matchClause(ASTFactory.NULL p, boolean optional, ASTFactory.NULL matchMode, List<ASTFactory.NULL> nulls, ASTFactory.NULL patternPos, List<ASTFactory.NULL> nulls2, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("matchClause is not a literal");
    }

    public ASTFactory.NULL usingIndexHint(ASTFactory.NULL p, Object v, String labelOrRelType, List<String> properties, boolean seekOnly, HintIndexType indexType) {
        throw new UnsupportedOperationException("usingIndexHint is not a literal");
    }

    public ASTFactory.NULL usingJoin(ASTFactory.NULL p, List<Object> joinVariables) {
        throw new UnsupportedOperationException("usingJoin is not a literal");
    }

    public ASTFactory.NULL usingScan(ASTFactory.NULL p, Object v, String labelOrRelType) {
        throw new UnsupportedOperationException("usingScan is not a literal");
    }

    public ASTFactory.NULL createClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("createClause is not a literal");
    }

    public ASTFactory.NULL setClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("setClause is not a literal");
    }

    public ASTFactory.NULL setProperty(Object o, Object value) {
        throw new UnsupportedOperationException("setProperty is not a literal");
    }

    public ASTFactory.NULL setVariable(Object o, Object value) {
        throw new UnsupportedOperationException("setVariable is not a literal");
    }

    public ASTFactory.NULL addAndSetVariable(Object o, Object value) {
        throw new UnsupportedOperationException("addAndSetVariable is not a literal");
    }

    public ASTFactory.NULL setLabels(Object o, List<ASTFactory.StringPos<ASTFactory.NULL>> value, boolean containsIs) {
        throw new UnsupportedOperationException("setLabels is not a literal");
    }

    public ASTFactory.NULL removeClause(ASTFactory.NULL p, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("removeClause is not a literal");
    }

    public ASTFactory.NULL removeProperty(Object o) {
        throw new UnsupportedOperationException("removeProperty is not a literal");
    }

    public ASTFactory.NULL removeLabels(Object o, List<ASTFactory.StringPos<ASTFactory.NULL>> labels, boolean containsIs) {
        throw new UnsupportedOperationException("removeLabels is not a literal");
    }

    public ASTFactory.NULL deleteClause(ASTFactory.NULL p, boolean detach, List<Object> objects) {
        throw new UnsupportedOperationException("deleteClause is not a literal");
    }

    public ASTFactory.NULL unwindClause(ASTFactory.NULL p, Object e, Object v) {
        throw new UnsupportedOperationException("unwindClause is not a literal");
    }

    public ASTFactory.NULL mergeClause(ASTFactory.NULL p, ASTFactory.NULL aNull, List<ASTFactory.NULL> setClauses, List<ASTFactory.MergeActionType> actionTypes, List<ASTFactory.NULL> positions) {
        throw new UnsupportedOperationException("mergeClause is not a literal");
    }

    public ASTFactory.NULL callClause(ASTFactory.NULL p, ASTFactory.NULL procedureResultPosition, ASTFactory.NULL procedureNamePosition, ASTFactory.NULL namespacePosition, List<String> namespace, String name, List<Object> arguments, boolean yieldAll, List<ASTFactory.NULL> nulls, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("callClause is not a literal");
    }

    public ASTFactory.NULL callResultItem(ASTFactory.NULL p, String name, Object v) {
        throw new UnsupportedOperationException("callResultItem is not a literal");
    }

    public ASTFactory.NULL patternWithSelector(ASTFactory.NULL selector, ASTFactory.NULL patternPart) {
        throw new UnsupportedOperationException("patternWithSelector is not a literal");
    }

    public ASTFactory.NULL namedPattern(Object v, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("namedPattern is not a literal");
    }

    public ASTFactory.NULL shortestPathPattern(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("shortestPathPattern is not a literal");
    }

    public ASTFactory.NULL allShortestPathsPattern(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("allShortestPathsPattern is not a literal");
    }

    public ASTFactory.NULL pathPattern(ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("pathPattern is not a literal");
    }

    public ASTFactory.NULL patternElement(List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("patternElement is not a literal");
    }

    public ASTFactory.NULL anyPathSelector(String count, ASTFactory.NULL pCount, ASTFactory.NULL p) {
        throw new UnsupportedOperationException("anyPathSelector is not a literal");
    }

    public ASTFactory.NULL allPathSelector(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allPathSelector is not a literal");
    }

    public ASTFactory.NULL anyShortestPathSelector(String count, ASTFactory.NULL pCount, ASTFactory.NULL p) {
        throw new UnsupportedOperationException("anyShortestPathSelector is not a literal");
    }

    public ASTFactory.NULL allShortestPathSelector(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allShortestPathSelector is not a literal");
    }

    public ASTFactory.NULL shortestGroupsSelector(String count, ASTFactory.NULL countPosition, ASTFactory.NULL position) {
        throw new UnsupportedOperationException("shortestGroupsSelector is not a literal");
    }

    public ASTFactory.NULL nodePattern(ASTFactory.NULL p, Object v, ASTFactory.NULL aNull, Object properties, Object predicate) {
        throw new UnsupportedOperationException("nodePattern is not a literal");
    }

    public ASTFactory.NULL relationshipPattern(ASTFactory.NULL p, boolean left, boolean right, Object v, ASTFactory.NULL labelExpression, ASTFactory.NULL aNull, Object properties, Object predicate) {
        throw new UnsupportedOperationException("relationshipPattern is not a literal");
    }

    public ASTFactory.NULL pathLength(ASTFactory.NULL p, ASTFactory.NULL pMin, ASTFactory.NULL mMax, String minLength, String maxLength) {
        throw new UnsupportedOperationException("pathLength is not a literal");
    }

    public ASTFactory.NULL intervalPathQuantifier(ASTFactory.NULL p, ASTFactory.NULL posLowerBound, ASTFactory.NULL posUpperBound, String lowerBound, String upperBound) {
        throw new UnsupportedOperationException("intervalPathQuantifier is not a literal");
    }

    public ASTFactory.NULL fixedPathQuantifier(ASTFactory.NULL p, ASTFactory.NULL valuePos, String value) {
        throw new UnsupportedOperationException("fixedPathQuantifier is not a literal");
    }

    public ASTFactory.NULL plusPathQuantifier(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("plusPathQuantifier is not a literal");
    }

    public ASTFactory.NULL starPathQuantifier(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("starPathQuantifier is not a literal");
    }

    public ASTFactory.NULL repeatableElements(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("repeatableElements is not a literal");
    }

    public ASTFactory.NULL differentRelationships(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("differentRelationships is not a literal");
    }

    public ASTFactory.NULL parenthesizedPathPattern(ASTFactory.NULL p, ASTFactory.NULL internalPattern, Object where, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("parenthesizedPathPattern is not a literal");
    }

    public ASTFactory.NULL quantifiedRelationship(ASTFactory.NULL rel, ASTFactory.NULL quantifier) {
        throw new UnsupportedOperationException("quantifiedRelationship is not a literal");
    }

    public ASTFactory.NULL loadCsvClause(ASTFactory.NULL p, boolean headers, Object source, Object v, String fieldTerminator) {
        throw new UnsupportedOperationException("loadCsvClause is not a literal");
    }

    public ASTFactory.NULL foreachClause(ASTFactory.NULL p, Object v, Object list, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("foreachClause is not a literal");
    }

    public ASTFactory.NULL subqueryClause(ASTFactory.NULL p, ASTFactory.NULL subquery, ASTFactory.NULL inTransactions) {
        throw new UnsupportedOperationException("subqueryClause is not a literal");
    }

    public ASTFactory.NULL subqueryInTransactionsParams(ASTFactory.NULL p, ASTFactory.NULL batchParams, ASTFactory.NULL errorParams, ASTFactory.NULL reportParams) {
        throw new UnsupportedOperationException("subqueryInTransactionsParams is not a literal");
    }

    public ASTFactory.NULL subqueryInTransactionsBatchParameters(ASTFactory.NULL p, Object batchSize) {
        throw new UnsupportedOperationException("subqueryInTransactionsBatchParameters is not a literal");
    }

    public ASTFactory.NULL subqueryInTransactionsErrorParameters(ASTFactory.NULL p, CallInTxsOnErrorBehaviourType onErrorBehaviour) {
        throw new UnsupportedOperationException("subqueryInTransactionsErrorParameters is not a literal");
    }

    public ASTFactory.NULL subqueryInTransactionsReportParameters(ASTFactory.NULL p, Object v) {
        throw new UnsupportedOperationException("subqueryInTransactionsReportParameters is not a literal");
    }

    public ASTFactory.NULL yieldClause(ASTFactory.NULL p, boolean returnAll, List<ASTFactory.NULL> nulls, ASTFactory.NULL returnItemsPosition, List<ASTFactory.NULL> orderBy, ASTFactory.NULL orderPos, Object skip, ASTFactory.NULL skipPosition, Object limit, ASTFactory.NULL limitPosition, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("yieldClause is not a literal");
    }

    public ASTFactory.NULL showIndexClause(ASTFactory.NULL p, ShowCommandFilterTypes indexType, boolean brief, boolean verbose, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("showIndexClause is not a literal");
    }

    public ASTFactory.NULL showConstraintClause(ASTFactory.NULL p, ShowCommandFilterTypes constraintType, boolean brief, boolean verbose, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("showConstraintClause is not a literal");
    }

    public ASTFactory.NULL showProcedureClause(ASTFactory.NULL p, boolean currentUser, String user, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("showProcedureClause is not a literal");
    }

    public ASTFactory.NULL showFunctionClause(ASTFactory.NULL p, ShowCommandFilterTypes functionType, boolean currentUser, String user, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("showFunctionClause is not a literal");
    }

    public ASTFactory.NULL showTransactionsClause(ASTFactory.NULL p, SimpleEither<List<String>, Object> ids, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("showTransactionsClause is not a literal");
    }

    public ASTFactory.NULL terminateTransactionsClause(ASTFactory.NULL p, SimpleEither<List<String>, Object> ids, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("terminateTransactionsClause is not a literal");
    }

    public ASTFactory.NULL showSettingsClause(ASTFactory.NULL p, SimpleEither<List<String>, Object> ids, ASTFactory.NULL where, ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("showSettingsClause is not a literal");
    }

    public ASTFactory.NULL turnYieldToWith(ASTFactory.NULL yieldClause) {
        throw new UnsupportedOperationException("turnYieldToWith is not a literal");
    }

    public ASTFactory.NULL createConstraint(ASTFactory.NULL p, ConstraintType constraintType, boolean replace, boolean ifNotExists, SimpleEither<String, Object> name, Object o, ASTFactory.StringPos<ASTFactory.NULL> label, List<Object> objects, ParserCypherTypeName propertyType, SimpleEither<Map<String, Object>, Object> options, boolean containsOn, ConstraintVersion constraintVersion) {
        throw new UnsupportedOperationException("createConstraint is not a literal");
    }

    public ASTFactory.NULL dropConstraint(ASTFactory.NULL p, SimpleEither<String, Object> name, boolean ifExists) {
        throw new UnsupportedOperationException("dropConstraint is not a literal");
    }

    public ASTFactory.NULL dropConstraint(ASTFactory.NULL p, ConstraintType constraintType, Object o, ASTFactory.StringPos<ASTFactory.NULL> label, List<Object> objects) {
        throw new UnsupportedOperationException("dropConstraint is not a literal");
    }

    public ASTFactory.NULL createIndexWithOldSyntax(ASTFactory.NULL p, ASTFactory.StringPos<ASTFactory.NULL> label, List<ASTFactory.StringPos<ASTFactory.NULL>> properties) {
        throw new UnsupportedOperationException("createIndexWithOldSyntax is not a literal");
    }

    public ASTFactory.NULL createLookupIndex(ASTFactory.NULL p, boolean replace, boolean ifNotExists, boolean isNode, SimpleEither<String, Object> indexName, Object o, ASTFactory.StringPos<ASTFactory.NULL> functionName, Object functionParameter, SimpleEither<Map<String, Object>, Object> options) {
        throw new UnsupportedOperationException("createLookupIndex is not a literal");
    }

    public ASTFactory.NULL createIndex(ASTFactory.NULL p, boolean replace, boolean ifNotExists, boolean isNode, SimpleEither<String, Object> indexName, Object o, ASTFactory.StringPos<ASTFactory.NULL> label, List<Object> objects, SimpleEither<Map<String, Object>, Object> options, CreateIndexTypes indexType) {
        throw new UnsupportedOperationException("createIndex is not a literal");
    }

    public ASTFactory.NULL createFulltextIndex(ASTFactory.NULL p, boolean replace, boolean ifNotExists, boolean isNode, SimpleEither<String, Object> indexName, Object o, List<ASTFactory.StringPos<ASTFactory.NULL>> labels, List<Object> objects, SimpleEither<Map<String, Object>, Object> options) {
        throw new UnsupportedOperationException("createFulltextIndex is not a literal");
    }

    public ASTFactory.NULL dropIndex(ASTFactory.NULL p, SimpleEither<String, Object> name, boolean ifExists) {
        throw new UnsupportedOperationException("dropIndex is not a literal");
    }

    public ASTFactory.NULL dropIndex(ASTFactory.NULL p, ASTFactory.StringPos<ASTFactory.NULL> label, List<ASTFactory.StringPos<ASTFactory.NULL>> propertyNames) {
        throw new UnsupportedOperationException("dropIndex is not a literal");
    }

    public ASTFactory.NULL useGraph(ASTFactory.NULL aNull, ASTFactory.NULL aNull2) {
        throw new UnsupportedOperationException("useGraph is not a literal");
    }

    public ASTFactory.NULL createRole(ASTFactory.NULL p, boolean replace, SimpleEither<String, Object> roleName, SimpleEither<String, Object> from, boolean ifNotExists) {
        throw new UnsupportedOperationException("createRole is not a literal");
    }

    public ASTFactory.NULL dropRole(ASTFactory.NULL p, SimpleEither<String, Object> roleName, boolean ifExists) {
        throw new UnsupportedOperationException("dropRole is not a literal");
    }

    public ASTFactory.NULL renameRole(ASTFactory.NULL p, SimpleEither<String, Object> fromRoleName, SimpleEither<String, Object> toRoleName, boolean ifExists) {
        throw new UnsupportedOperationException("renameRole is not a literal");
    }

    public ASTFactory.NULL showRoles(ASTFactory.NULL p, boolean withUsers, boolean showAll, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showRoles is not a literal");
    }

    public ASTFactory.NULL grantRoles(ASTFactory.NULL p, List<SimpleEither<String, Object>> roles, List<SimpleEither<String, Object>> users) {
        throw new UnsupportedOperationException("grantRoles is not a literal");
    }

    public ASTFactory.NULL revokeRoles(ASTFactory.NULL p, List<SimpleEither<String, Object>> roles, List<SimpleEither<String, Object>> users) {
        throw new UnsupportedOperationException("revokeRoles is not a literal");
    }

    public ASTFactory.NULL createUser(ASTFactory.NULL p, boolean replace, boolean ifNotExists, SimpleEither<String, Object> username, Object password, boolean encrypted, boolean changeRequired, Boolean suspended, ASTFactory.NULL homeDatabase) {
        throw new UnsupportedOperationException("createUser is not a literal");
    }

    public ASTFactory.NULL dropUser(ASTFactory.NULL p, boolean ifExists, SimpleEither<String, Object> username) {
        throw new UnsupportedOperationException("dropUser is not a literal");
    }

    public ASTFactory.NULL renameUser(ASTFactory.NULL p, SimpleEither<String, Object> fromUserName, SimpleEither<String, Object> toUserName, boolean ifExists) {
        throw new UnsupportedOperationException("renameUser is not a literal");
    }

    public ASTFactory.NULL setOwnPassword(ASTFactory.NULL p, Object currentPassword, Object newPassword) {
        throw new UnsupportedOperationException("setOwnPassword is not a literal");
    }

    public ASTFactory.NULL alterUser(ASTFactory.NULL p, boolean ifExists, SimpleEither<String, Object> username, Object password, boolean encrypted, Boolean changeRequired, Boolean suspended, ASTFactory.NULL homeDatabase, boolean removeHome) {
        throw new UnsupportedOperationException("alterUser is not a literal");
    }

    public Object passwordExpression(Object password) {
        throw new UnsupportedOperationException("passwordExpression is not a literal");
    }

    public Object passwordExpression(ASTFactory.NULL p, String password) {
        throw new UnsupportedOperationException("passwordExpression is not a literal");
    }

    public ASTFactory.NULL showUsers(ASTFactory.NULL p, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showUsers is not a literal");
    }

    public ASTFactory.NULL showCurrentUser(ASTFactory.NULL p, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showCurrentUser is not a literal");
    }

    public ASTFactory.NULL showSupportedPrivileges(ASTFactory.NULL p, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("showSupportedPrivileges is not a literal");
    }

    public ASTFactory.NULL showAllPrivileges(ASTFactory.NULL p, boolean asCommand, boolean asRevoke, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showAllPrivileges is not a literal");
    }

    public ASTFactory.NULL showRolePrivileges(ASTFactory.NULL p, List<SimpleEither<String, Object>> roles, boolean asCommand, boolean asRevoke, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showRolePrivileges is not a literal");
    }

    public ASTFactory.NULL showUserPrivileges(ASTFactory.NULL p, List<SimpleEither<String, Object>> users, boolean asCommand, boolean asRevoke, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showUserPrivileges is not a literal");
    }

    public ASTFactory.NULL grantPrivilege(ASTFactory.NULL p, List<SimpleEither<String, Object>> roles, ASTFactory.NULL privilege) {
        throw new UnsupportedOperationException("grantPrivilege is not a literal");
    }

    public ASTFactory.NULL denyPrivilege(ASTFactory.NULL p, List<SimpleEither<String, Object>> roles, ASTFactory.NULL privilege) {
        throw new UnsupportedOperationException("denyPrivilege is not a literal");
    }

    public ASTFactory.NULL revokePrivilege(ASTFactory.NULL p, List<SimpleEither<String, Object>> roles, ASTFactory.NULL privilege, boolean revokeGrant, boolean revokeDeny) {
        throw new UnsupportedOperationException("revokePrivilege is not a literal");
    }

    public ASTFactory.NULL databasePrivilege(ASTFactory.NULL p, ASTFactory.NULL action, ASTFactory.NULL scope, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException("databasePrivilege is not a literal");
    }

    public ASTFactory.NULL dbmsPrivilege(ASTFactory.NULL p, ASTFactory.NULL action, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException("dbmsPrivilege is not a literal");
    }

    public ASTFactory.NULL graphPrivilege(ASTFactory.NULL p, ASTFactory.NULL action, ASTFactory.NULL scope, ASTFactory.NULL resource, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException("graphPrivilege is not a literal");
    }

    public ASTFactory.NULL loadPrivilege(ASTFactory.NULL p, SimpleEither<String, Object> url, SimpleEither<String, Object> cidr, boolean immutable) {
        throw new UnsupportedOperationException("loadPrivilege is not a literal");
    }

    public ASTFactory.NULL privilegeAction(ActionType action) {
        throw new UnsupportedOperationException("privilegeAction is not a literal");
    }

    public ASTFactory.NULL propertiesResource(ASTFactory.NULL p, List<String> property) {
        throw new UnsupportedOperationException("propertiesResource is not a literal");
    }

    public ASTFactory.NULL allPropertiesResource(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allPropertiesResource is not a literal");
    }

    public ASTFactory.NULL labelsResource(ASTFactory.NULL p, List<String> label) {
        throw new UnsupportedOperationException("labelsResource is not a literal");
    }

    public ASTFactory.NULL allLabelsResource(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allLabelsResource is not a literal");
    }

    public ASTFactory.NULL databaseResource(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("databaseResource is not a literal");
    }

    public ASTFactory.NULL noResource(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("noResource is not a literal");
    }

    public ASTFactory.NULL labelQualifier(ASTFactory.NULL p, String label) {
        throw new UnsupportedOperationException("labelQualifier is not a literal");
    }

    public ASTFactory.NULL allLabelsQualifier(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allLabelsQualifier is not a literal");
    }

    public ASTFactory.NULL relationshipQualifier(ASTFactory.NULL p, String relationshipType) {
        throw new UnsupportedOperationException("relationshipQualifier is not a literal");
    }

    public ASTFactory.NULL allRelationshipsQualifier(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allRelationshipsQualifier is not a literal");
    }

    public ASTFactory.NULL elementQualifier(ASTFactory.NULL p, String name) {
        throw new UnsupportedOperationException("elementQualifier is not a literal");
    }

    public ASTFactory.NULL allElementsQualifier(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("allElementsQualifier is not a literal");
    }

    public ASTFactory.NULL patternQualifier(List<ASTFactory.NULL> qualifiers, Object variable, Object where) {
        throw new UnsupportedOperationException("patternQualifier is not a literal");
    }

    public List<ASTFactory.NULL> allQualifier() {
        throw new UnsupportedOperationException("allQualifier is not a literal");
    }

    public List<ASTFactory.NULL> allDatabasesQualifier() {
        throw new UnsupportedOperationException("allDatabasesQualifier is not a literal");
    }

    public List<ASTFactory.NULL> userQualifier(List<SimpleEither<String, Object>> users) {
        throw new UnsupportedOperationException("userQualifier is not a literal");
    }

    public List<ASTFactory.NULL> allUsersQualifier() {
        throw new UnsupportedOperationException("allUsersQualifier is not a literal");
    }

    public List<ASTFactory.NULL> functionQualifier(ASTFactory.NULL p, List<String> functions) {
        throw new UnsupportedOperationException("functionQualifier is not a literal");
    }

    public List<ASTFactory.NULL> procedureQualifier(ASTFactory.NULL p, List<String> procedures) {
        throw new UnsupportedOperationException("procedureQualifier is not a literal");
    }

    public List<ASTFactory.NULL> settingQualifier(ASTFactory.NULL p, List<String> names) {
        throw new UnsupportedOperationException("settingQualifier is not a literal");
    }

    public ASTFactory.NULL graphScope(ASTFactory.NULL p, List<ASTFactory.NULL> graphNames, ScopeType scopeType) {
        throw new UnsupportedOperationException("graphScope is not a literal");
    }

    public ASTFactory.NULL databaseScope(ASTFactory.NULL p, List<ASTFactory.NULL> databaseNames, ScopeType scopeType) {
        throw new UnsupportedOperationException("databaseScope is not a literal");
    }

    public ASTFactory.NULL enableServer(ASTFactory.NULL p, SimpleEither<String, Object> serverName, SimpleEither<Map<String, Object>, Object> options) {
        throw new UnsupportedOperationException("enableServer is not a literal");
    }

    public ASTFactory.NULL alterServer(ASTFactory.NULL p, SimpleEither<String, Object> serverName, SimpleEither<Map<String, Object>, Object> options) {
        throw new UnsupportedOperationException("alterServer is not a literal");
    }

    public ASTFactory.NULL renameServer(ASTFactory.NULL p, SimpleEither<String, Object> serverName, SimpleEither<String, Object> newName) {
        throw new UnsupportedOperationException("renameServer is not a literal");
    }

    public ASTFactory.NULL dropServer(ASTFactory.NULL p, SimpleEither<String, Object> serverName) {
        throw new UnsupportedOperationException("dropServer is not a literal");
    }

    public ASTFactory.NULL showServers(ASTFactory.NULL p, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("showServers is not a literal");
    }

    public ASTFactory.NULL deallocateServers(ASTFactory.NULL p, boolean dryRun, List<SimpleEither<String, Object>> serverNames) {
        throw new UnsupportedOperationException("deallocateServers is not a literal");
    }

    public ASTFactory.NULL reallocateDatabases(ASTFactory.NULL p, boolean dryRun) {
        throw new UnsupportedOperationException("reallocateDatabases is not a literal");
    }

    public ASTFactory.NULL createDatabase(ASTFactory.NULL p, boolean replace, ASTFactory.NULL databaseName, boolean ifNotExists, ASTFactory.NULL aNull, SimpleEither<Map<String, Object>, Object> options, Integer topologyPrimaries, Integer topologySecondaries) {
        throw new UnsupportedOperationException("createDatabase is not a literal");
    }

    public ASTFactory.NULL dropDatabase(ASTFactory.NULL p, ASTFactory.NULL databaseName, boolean ifExists, boolean composite, boolean dumpData, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("dropDatabase is not a literal");
    }

    public ASTFactory.NULL alterDatabase(ASTFactory.NULL p, ASTFactory.NULL databaseName, boolean ifExists, AccessType accessType, Integer topologyPrimaries, Integer topologySecondaries, Map<String, Object> options, Set<String> optionsToRemove, ASTFactory.NULL waitClause) {
        throw new UnsupportedOperationException("alterDatabase is not a literal");
    }

    public ASTFactory.NULL showDatabase(ASTFactory.NULL p, ASTFactory.NULL aNull, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("showDatabase is not a literal");
    }

    public ASTFactory.NULL createCompositeDatabase(ASTFactory.NULL p, boolean replace, ASTFactory.NULL compositeDatabaseName, boolean ifNotExists, SimpleEither<Map<String, Object>, Object> options, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("createCompositeDatabase is not a literal");
    }

    public ASTFactory.NULL databaseScope(ASTFactory.NULL p, ASTFactory.NULL name, boolean isDefault, boolean isHome) {
        throw new UnsupportedOperationException("databaseScope is not a literal");
    }

    public ASTFactory.NULL startDatabase(ASTFactory.NULL p, ASTFactory.NULL databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("startDatabase is not a literal");
    }

    public ASTFactory.NULL stopDatabase(ASTFactory.NULL p, ASTFactory.NULL databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException("stopDatabase is not a literal");
    }

    public ASTFactory.NULL wait(boolean wait, long seconds) {
        throw new UnsupportedOperationException("wait is not a literal");
    }

    public ASTFactory.NULL createLocalDatabaseAlias(ASTFactory.NULL p, boolean replace, ASTFactory.NULL aliasName, ASTFactory.NULL targetName, boolean ifNotExists, SimpleEither<Map<String, Object>, Object> properties) {
        throw new UnsupportedOperationException("createLocalDatabaseAlias is not a literal");
    }

    public ASTFactory.NULL createRemoteDatabaseAlias(ASTFactory.NULL p, boolean replace, ASTFactory.NULL aliasName, ASTFactory.NULL targetName, boolean ifNotExists, SimpleEither<String, Object> url, SimpleEither<String, Object> username, Object password, SimpleEither<Map<String, Object>, Object> driverSettings, SimpleEither<Map<String, Object>, Object> properties) {
        throw new UnsupportedOperationException("createRemoteDatabaseAlias is not a literal");
    }

    public ASTFactory.NULL alterLocalDatabaseAlias(ASTFactory.NULL p, ASTFactory.NULL aliasName, ASTFactory.NULL targetName, boolean ifExists, SimpleEither<Map<String, Object>, Object> properties) {
        throw new UnsupportedOperationException("alterLocalDatabaseAlias is not a literal");
    }

    public ASTFactory.NULL alterRemoteDatabaseAlias(ASTFactory.NULL p, ASTFactory.NULL aliasName, ASTFactory.NULL targetName, boolean ifExists, SimpleEither<String, Object> url, SimpleEither<String, Object> username, Object password, SimpleEither<Map<String, Object>, Object> driverSettings, SimpleEither<Map<String, Object>, Object> properties) {
        throw new UnsupportedOperationException("alterRemoteDatabaseAlias is not a literal");
    }

    public ASTFactory.NULL dropAlias(ASTFactory.NULL p, ASTFactory.NULL aliasName, boolean ifExists) {
        throw new UnsupportedOperationException("dropAlias is not a literal");
    }

    public ASTFactory.NULL showAliases(ASTFactory.NULL p, ASTFactory.NULL aliasName, ASTFactory.NULL yieldExpr, ASTFactory.NULL returnWithoutGraph, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("showAliases is not a literal");
    }

    public void addDeprecatedIdentifierUnicodeNotification(ASTFactory.NULL p, Character character, String identifier) {
        throw new UnsupportedOperationException("This deprecation shouldn't occur in a literal.");
    }

    public Object newVariable(ASTFactory.NULL p, String name) {
        throw new UnsupportedOperationException("newVariable is not a literal");
    }

    public Object newParameter(ASTFactory.NULL p, Object v, ParameterType type) {
        throw new UnsupportedOperationException("newParameter is not a literal");
    }

    public Object newParameter(ASTFactory.NULL p, String offset, ParameterType type) {
        throw new UnsupportedOperationException("newParameter is not a literal");
    }

    public Object newSensitiveStringParameter(ASTFactory.NULL p, Object v) {
        throw new UnsupportedOperationException("newSensitiveStringParameter is not a literal");
    }

    public Object newSensitiveStringParameter(ASTFactory.NULL p, String offset) {
        throw new UnsupportedOperationException("newSensitiveStringParameter is not a literal");
    }

    public Object newDouble(ASTFactory.NULL p, String image) {
        return Double.valueOf(image);
    }

    public Object newDecimalInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_DECIMAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    public Object newHexInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = Long.parseLong(image.substring(2), 16);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && LONG_MIN_VALUE_HEXADECIMAL_STRING.equals(image)) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    public Object newOctalInteger(ASTFactory.NULL p, String image, boolean negated) {
        try {
            long x = image.charAt(1) == 'o' ? Long.parseLong(image.substring(2), 8) : Long.parseLong(image, 8);
            return negated ? -x : x;
        }
        catch (NumberFormatException e) {
            if (negated && (LONG_MIN_VALUE_OCTAL_STRING.equals(image) || LONG_MIN_VALUE_OCTAL_STRING_OLD_SYNTAX.equals(image))) {
                return Long.MIN_VALUE;
            }
            throw e;
        }
    }

    public Object newString(ASTFactory.NULL p, String image) {
        return image;
    }

    public Object newTrueLiteral(ASTFactory.NULL p) {
        return Boolean.TRUE;
    }

    public Object newFalseLiteral(ASTFactory.NULL p) {
        return Boolean.FALSE;
    }

    public Object newInfinityLiteral(ASTFactory.NULL p) {
        return Double.POSITIVE_INFINITY;
    }

    public Object newNaNLiteral(ASTFactory.NULL p) {
        return Double.NaN;
    }

    public Object newNullLiteral(ASTFactory.NULL p) {
        return null;
    }

    public Object listLiteral(ASTFactory.NULL p, List<Object> values) {
        return values;
    }

    public Object mapLiteral(ASTFactory.NULL p, List<ASTFactory.StringPos<ASTFactory.NULL>> keys, List<Object> values) {
        HashMap<String, Object> x = new HashMap<String, Object>();
        Iterator<ASTFactory.StringPos<ASTFactory.NULL>> keyIterator = keys.iterator();
        Iterator<Object> valueIterator = values.iterator();
        while (keyIterator.hasNext()) {
            x.put(keyIterator.next().string, valueIterator.next());
        }
        return x;
    }

    public Object property(Object subject, ASTFactory.StringPos<ASTFactory.NULL> propertyKeyName) {
        throw new UnsupportedOperationException("property is not a literal");
    }

    public Object or(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("or is not a literal");
    }

    public Object xor(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("xor is not a literal");
    }

    public Object and(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("and is not a literal");
    }

    public ASTFactory.NULL labelConjunction(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean containsIs) {
        throw new UnsupportedOperationException("labelConjunction is not a literal");
    }

    public ASTFactory.NULL labelDisjunction(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean containsIs) {
        throw new UnsupportedOperationException("labelDisjunction is not a literal");
    }

    public ASTFactory.NULL labelNegation(ASTFactory.NULL p, ASTFactory.NULL e, boolean containsIs) {
        throw new UnsupportedOperationException("labelNegation is not a literal");
    }

    public ASTFactory.NULL labelWildcard(ASTFactory.NULL p, boolean containsIs) {
        throw new UnsupportedOperationException("labelWildcard is not a literal");
    }

    public ASTFactory.NULL labelLeaf(ASTFactory.NULL p, String e, ASTFactory.NULL entityType, boolean containsIs) {
        throw new UnsupportedOperationException("labelAtom is not a literal");
    }

    public ASTFactory.NULL labelColonConjunction(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean containsIs) {
        throw new UnsupportedOperationException("labelColonConjunction is not a literal");
    }

    public ASTFactory.NULL labelColonDisjunction(ASTFactory.NULL p, ASTFactory.NULL lhs, ASTFactory.NULL rhs, boolean containsIs) {
        throw new UnsupportedOperationException("labelColonDisjunction is not a literal");
    }

    public Object labelExpressionPredicate(Object subject, ASTFactory.NULL exp) {
        throw new UnsupportedOperationException("labelExpressionPredicate is not a literal");
    }

    public Object ands(List<Object> exprs) {
        throw new UnsupportedOperationException("ands is not a literal");
    }

    public Object not(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("not is not a literal");
    }

    public Object plus(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("plus is not a literal");
    }

    public Object minus(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("minus is not a literal");
    }

    public Object multiply(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("multiply is not a literal");
    }

    public Object divide(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("divide is not a literal");
    }

    public Object modulo(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("modulo is not a literal");
    }

    public Object pow(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("pow is not a literal");
    }

    public Object unaryPlus(Object e) {
        throw new UnsupportedOperationException("unaryPlus is not a literal");
    }

    public Object unaryPlus(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("unaryPlus is not a literal");
    }

    public Object unaryMinus(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("unaryMinus is not a literal");
    }

    public Object eq(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("eq is not a literal");
    }

    public Object neq(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("neq is not a literal");
    }

    public Object neq2(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("neq2 is not a literal");
    }

    public Object lte(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("lte is not a literal");
    }

    public Object gte(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("gte is not a literal");
    }

    public Object lt(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("lt is not a literal");
    }

    public Object gt(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("gt is not a literal");
    }

    public Object regeq(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("regeq is not a literal");
    }

    public Object startsWith(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("startsWith is not a literal");
    }

    public Object endsWith(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("endsWith is not a literal");
    }

    public Object contains(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("contains is not a literal");
    }

    public Object in(ASTFactory.NULL p, Object lhs, Object rhs) {
        throw new UnsupportedOperationException("in is not a literal");
    }

    public Object isNull(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("isNull is not a literal");
    }

    public Object isNotNull(ASTFactory.NULL p, Object e) {
        throw new UnsupportedOperationException("isNotNull is not a literal");
    }

    public Object isTyped(ASTFactory.NULL p, Object e, ParserCypherTypeName typeName) {
        throw new UnsupportedOperationException("isTyped is not a literal");
    }

    public Object isNotTyped(ASTFactory.NULL p, Object e, ParserCypherTypeName typeName) {
        throw new UnsupportedOperationException("isNotTyped is not a literal");
    }

    public Object listLookup(Object list, Object index) {
        throw new UnsupportedOperationException("listLookup is not a literal");
    }

    public Object listSlice(ASTFactory.NULL p, Object list, Object start, Object end) {
        throw new UnsupportedOperationException("listSlice is not a literal");
    }

    public Object newCountStar(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("newCountStar is not a literal");
    }

    public Object functionInvocation(ASTFactory.NULL p, ASTFactory.NULL functionNamePosition, List<String> namespace, String name, boolean distinct, List<Object> arguments) {
        if (namespace.isEmpty()) {
            switch (name.toLowerCase(Locale.ROOT)) {
                case "date": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, DateValue::now, DateValue::parse, DateValue::build);
                }
                case "datetime": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, DateTimeValue::now, s -> DateTimeValue.parse((CharSequence)s, () -> DEFAULT_ZONE_ID), DateTimeValue::build);
                }
                case "time": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, TimeValue::now, s -> TimeValue.parse((CharSequence)s, () -> DEFAULT_ZONE_ID), TimeValue::build);
                }
                case "localtime": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, LocalTimeValue::now, LocalTimeValue::parse, LocalTimeValue::build);
                }
                case "localdatetime": {
                    return LiteralInterpreter.createTemporalValue(arguments, name, LocalDateTimeValue::now, LocalDateTimeValue::parse, LocalDateTimeValue::build);
                }
                case "duration": {
                    return LiteralInterpreter.createDurationValue(arguments);
                }
                case "point": {
                    return LiteralInterpreter.createPoint(arguments);
                }
            }
            throw new UnsupportedOperationException("functionInvocation (" + name + ") is not a literal");
        }
        throw new UnsupportedOperationException("functionInvocation is not a literal");
    }

    private static PointValue createPoint(List<Object> arguments) {
        if (arguments.size() == 1) {
            Object point = arguments.get(0);
            if (point == null) {
                return null;
            }
            if (point instanceof Map) {
                Map pointAsMap = (Map)point;
                return PointValue.fromMap((MapValue)LiteralInterpreter.asMapValue(pointAsMap));
            }
            throw new IllegalArgumentException("Function `point` did not get expected argument. Expected a string or map input but got " + point.getClass().getSimpleName() + ".");
        }
        throw new IllegalArgumentException("Function `point` did not get expected number of arguments: expected 1 argument, got " + arguments.size() + " arguments.");
    }

    private static <T> T createTemporalValue(List<Object> arguments, String functionName, Function<Clock, T> onEmpty, Function<String, T> onString, BiFunction<MapValue, Supplier<ZoneId>, T> onMap) {
        if (arguments.isEmpty()) {
            return onEmpty.apply(Clock.system(DEFAULT_ZONE_ID));
        }
        if (arguments.size() == 1) {
            Object date = arguments.get(0);
            if (date == null) {
                return null;
            }
            if (date instanceof String) {
                return onString.apply((String)date);
            }
            if (date instanceof Map) {
                MapValue dateMap = LiteralInterpreter.asMapValue((Map)date);
                return onMap.apply(dateMap, () -> DEFAULT_ZONE_ID);
            }
        }
        throw new IllegalArgumentException("Function `" + functionName + "` did not get expected number of arguments: expected 0 or 1 argument, got " + arguments.size() + " arguments.");
    }

    private static DurationValue createDurationValue(List<Object> arguments) {
        if (arguments.size() == 1) {
            Object duration = arguments.get(0);
            if (duration instanceof String) {
                return DurationValue.parse((CharSequence)((String)duration));
            }
            if (duration instanceof Map) {
                MapValue dateMap = LiteralInterpreter.asMapValue((Map)duration);
                return DurationValue.build((MapValue)dateMap);
            }
        }
        throw new IllegalArgumentException("Function `duration` did not get expected number of arguments: expected 1 argument, got " + arguments.size() + " arguments.");
    }

    public Object listComprehension(ASTFactory.NULL p, Object v, Object list, Object where, Object projection) {
        throw new UnsupportedOperationException("listComprehension is not a literal");
    }

    public Object patternComprehension(ASTFactory.NULL p, ASTFactory.NULL relationshipPatternPosition, Object v, ASTFactory.NULL aNull, Object where, Object projection) {
        throw new UnsupportedOperationException("patternComprehension is not a literal");
    }

    public Object reduceExpression(ASTFactory.NULL p, Object acc, Object accExpr, Object v, Object list, Object innerExpr) {
        throw new UnsupportedOperationException("reduceExpression is not a literal");
    }

    public Object allExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("allExpression is not a literal");
    }

    public Object anyExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("anyExpression is not a literal");
    }

    public Object noneExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("noneExpression is not a literal");
    }

    public Object singleExpression(ASTFactory.NULL p, Object v, Object list, Object where) {
        throw new UnsupportedOperationException("singleExpression is not a literal");
    }

    public Object patternExpression(ASTFactory.NULL p, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException("patternExpression is not a literal");
    }

    public Object existsExpression(ASTFactory.NULL p, ASTFactory.NULL matchMode, List<ASTFactory.NULL> nulls, ASTFactory.NULL q, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("existsExpression is not a literal");
    }

    public Object countExpression(ASTFactory.NULL p, ASTFactory.NULL matchMode, List<ASTFactory.NULL> nulls, ASTFactory.NULL q, ASTFactory.NULL where) {
        throw new UnsupportedOperationException("countExpression is not a literal");
    }

    public Object collectExpression(ASTFactory.NULL p, ASTFactory.NULL q) {
        throw new UnsupportedOperationException("collectExpression is not a literal");
    }

    public Object mapProjection(ASTFactory.NULL p, Object v, List<ASTFactory.NULL> nulls) {
        throw new UnsupportedOperationException("mapProjection is not a literal");
    }

    public ASTFactory.NULL mapProjectionLiteralEntry(ASTFactory.StringPos<ASTFactory.NULL> property, Object value) {
        throw new UnsupportedOperationException("mapProjectionLiteralEntry is not a literal");
    }

    public ASTFactory.NULL mapProjectionProperty(ASTFactory.StringPos<ASTFactory.NULL> property) {
        throw new UnsupportedOperationException("mapProjectionProperty is not a literal");
    }

    public ASTFactory.NULL mapProjectionVariable(Object v) {
        throw new UnsupportedOperationException("mapProjectionVariable is not a literal");
    }

    public ASTFactory.NULL mapProjectionAll(ASTFactory.NULL p) {
        throw new UnsupportedOperationException("mapProjectionAll is not a literal");
    }

    public Object caseExpression(ASTFactory.NULL p, Object e, List<Object> whens, List<Object> thens, Object elze) {
        throw new UnsupportedOperationException("caseExpression is not a literal");
    }

    public ASTFactory.NULL inputPosition(int offset, int line, int column) {
        return null;
    }

    public ASTFactory.NULL nodeType() {
        return null;
    }

    public ASTFactory.NULL relationshipType() {
        return null;
    }

    public ASTFactory.NULL nodeOrRelationshipType() {
        return null;
    }

    public ASTFactory.NULL databaseName(ASTFactory.NULL pos, List<String> names) {
        throw new UnsupportedOperationException("databaseName is not a literal");
    }

    public ASTFactory.NULL databaseName(Object param) {
        throw new UnsupportedOperationException("databaseName is not a literal");
    }

    private static MapValue asMapValue(Map<String, ?> map) {
        int size = map.size();
        if (size == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(size);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            builder.add(entry.getKey(), (AnyValue)Values.of(entry.getValue()));
        }
        return builder.build();
    }
}

