/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import org.neo4j.memory.MemoryTracker;

public class ThreadSafePeakMemoryTracker
implements MemoryTracker {
    private final AtomicLong allocated = new AtomicLong();
    private final LongAccumulator peak = new LongAccumulator(Long::max, 0L);

    @Override
    public void allocateNative(long bytes) {
        long total = this.allocated.addAndGet(bytes);
        this.peak.accumulate(total);
    }

    @Override
    public void releaseNative(long bytes) {
        this.allocated.addAndGet(-bytes);
    }

    @Override
    public void allocateHeap(long bytes) {
    }

    @Override
    public void releaseHeap(long bytes) {
    }

    @Override
    public long heapHighWaterMark() {
        return 0L;
    }

    @Override
    public void reset() {
    }

    @Override
    public MemoryTracker getScopedMemoryTracker() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long usedNativeMemory() {
        return this.allocated.get();
    }

    @Override
    public long estimatedHeapMemory() {
        return 0L;
    }

    public long peakMemoryUsage() {
        return this.peak.get();
    }
}

