/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.common.Subject;

public class JobMonitoringParams {
    public static final JobMonitoringParams NOT_MONITORED = new JobMonitoringParams(null, null, null, null);
    private final Subject submitter;
    private final String targetDatabaseName;
    private final String description;
    private final Supplier<String> currentStateDescriptionSupplier;

    public JobMonitoringParams(Subject submitter, String targetDatabaseName, String description, Supplier<String> currentStateDescriptionSupplier) {
        this.submitter = Objects.requireNonNullElse(submitter, Subject.AUTH_DISABLED);
        this.targetDatabaseName = targetDatabaseName;
        this.description = description;
        this.currentStateDescriptionSupplier = currentStateDescriptionSupplier;
    }

    public JobMonitoringParams(Subject submitter, String targetDatabaseName, String description) {
        this(submitter, targetDatabaseName, description, null);
    }

    public static JobMonitoringParams systemJob(String description) {
        return new JobMonitoringParams(Subject.SYSTEM, null, description);
    }

    public static JobMonitoringParams systemJob(String targetDatabaseName, String description) {
        return new JobMonitoringParams(Subject.SYSTEM, targetDatabaseName, description);
    }

    public Subject getSubmitter() {
        return this.submitter;
    }

    public String getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCurrentStateDescription() {
        if (this.currentStateDescriptionSupplier == null) {
            return null;
        }
        return this.currentStateDescriptionSupplier.get();
    }

    public String toString() {
        return "JobMonitoringParams{submitter=" + this.submitter + ", targetDatabaseName='" + this.targetDatabaseName + "', description='" + this.description + "'}";
    }
}

