/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.diffset;

import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.collection.diffset.MutableLongDiffSetsImpl;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class RemovalsCountingDiffSets
extends MutableLongDiffSetsImpl {
    private static final long REMOVALS_COUNTING_DIFF_SET_SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(RemovalsCountingDiffSets.class);
    private final CollectionsFactory collectionsFactory;
    private final MemoryTracker memoryTracker;
    private MutableLongSet removedFromAdded;

    static RemovalsCountingDiffSets newRemovalsCountingDiffSets(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(REMOVALS_COUNTING_DIFF_SET_SHALLOW_SIZE);
        return new RemovalsCountingDiffSets(collectionsFactory, memoryTracker);
    }

    private RemovalsCountingDiffSets(CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        super(collectionsFactory, memoryTracker);
        this.collectionsFactory = collectionsFactory;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public boolean remove(long elem) {
        if (this.isAdded(elem) && super.remove(elem)) {
            if (this.removedFromAdded == null) {
                this.removedFromAdded = this.collectionsFactory.newLongSet(this.memoryTracker);
            }
            this.removedFromAdded.add(elem);
            return true;
        }
        return super.remove(elem);
    }

    @Override
    public LongSet getRemovedFromAdded() {
        return this.removedFromAdded != null ? this.removedFromAdded : LongSets.immutable.empty();
    }

    public boolean wasRemoved(long id) {
        return this.removedFromAdded != null && this.removedFromAdded.contains(id) || super.isRemoved(id);
    }
}

