/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Collections;
import java.util.List;
import org.neo4j.shell.exception.CypherShellIOException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface Historian {
    public static final Historian empty = new EmptyHistory();
    public static final boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");

    public List<String> getHistory();

    public void flushHistory() throws IOException;

    public void clear() throws IOException;

    public static Path defaultHistoryFile() {
        Path path = Path.of(System.getProperty("user.home"), ".neo4j", ".cypher_shell_history");
        return Historian.defaultHistoryFile(path);
    }

    public static Path defaultHistoryFile(Path path) {
        try {
            Path historyFile;
            Path path2 = historyFile = Historian.safeExists(path) ? path : Historian.createFileAndDirectories(path);
            if (isPosix) {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rw-------"));
            }
            return historyFile;
        }
        catch (IOException e) {
            throw new CypherShellIOException(e);
        }
    }

    private static boolean safeExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new CypherShellIOException("History file cannot be a directory, please delete " + path);
            }
            return true;
        }
        return false;
    }

    private static Path createFileAndDirectories(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try {
            return Files.createFile(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return path;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class EmptyHistory
    implements Historian {
        @Override
        public List<String> getHistory() {
            return Collections.emptyList();
        }

        @Override
        public void flushHistory() throws IOException {
        }

        @Override
        public void clear() throws IOException {
        }
    }
}

