/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.driver.internal.adaptedbolt.AdaptingDriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.value.BoltValueFactory;

final class AdaptingDriverBoltConnection
implements DriverBoltConnection {
    private final BoltConnection connection;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;

    AdaptingDriverBoltConnection(BoltConnection connection, ErrorMapper errorMapper, BoltValueFactory boltValueFactory) {
        this.connection = Objects.requireNonNull(connection);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
    }

    @Override
    public CompletionStage<Void> writeAndFlush(DriverResponseHandler handler, List<Message> messages) {
        return this.connection.writeAndFlush((ResponseHandler)new AdaptingDriverResponseHandler(handler, this.errorMapper, this.boltValueFactory), messages).exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<Void> write(List<Message> messages) {
        return this.connection.write(messages).exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        return this.connection.forceClose(reason).exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connection.close().exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public CompletionStage<AuthInfo> authData() {
        return this.connection.authInfo().exceptionally(this.errorMapper::mapAndThrow);
    }

    @Override
    public String serverAgent() {
        return this.connection.serverAgent();
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.connection.serverAddress();
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.connection.protocolVersion();
    }

    @Override
    public boolean telemetrySupported() {
        return this.connection.telemetrySupported();
    }

    @Override
    public boolean serverSideRoutingEnabled() {
        return this.connection.serverSideRoutingEnabled();
    }

    @Override
    public BoltValueFactory valueFactory() {
        return this.boltValueFactory;
    }
}

