/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ResultConsumedException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.internal.GqlStatusError;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static ServiceUnavailableException newConnectionTerminatedError(String reason) {
        if (reason == null) {
            return ErrorUtil.newConnectionTerminatedError();
        }
        return new ServiceUnavailableException("Connection to the database terminated. " + reason);
    }

    public static ServiceUnavailableException newConnectionTerminatedError() {
        return new ServiceUnavailableException("Connection to the database terminated. Please ensure that your database is listening on the correct host and port and that you have compatible encryption settings both on Neo4j server and driver. Note that the default encryption setting has changed in Neo4j 4.0.");
    }

    public static ResultConsumedException newResultConsumedError() {
        return new ResultConsumedException("Cannot access records on this result any more as the result has already been consumed or the query runner where the result is created has already been closed.");
    }

    public static void rethrowAsyncException(ExecutionException e) {
        RuntimeException exception;
        Throwable error = e.getCause();
        InternalExceptionCause internalCause = new InternalExceptionCause(error.getStackTrace());
        error.addSuppressed(internalCause);
        StackTraceElement[] currentStackTrace = (StackTraceElement[])Stream.of(Thread.currentThread().getStackTrace()).skip(2L).toArray(StackTraceElement[]::new);
        error.setStackTrace(currentStackTrace);
        if (error instanceof RuntimeException) {
            exception = (RuntimeException)error;
        } else {
            String message = "Driver execution failed";
            exception = new Neo4jException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, error);
        }
        throw exception;
    }

    public static void addSuppressed(Throwable mainError, Throwable error) {
        if (mainError != error) {
            mainError.addSuppressed(error);
        }
    }

    private static class InternalExceptionCause
    extends RuntimeException {
        private static final long serialVersionUID = -1988733529334222027L;

        InternalExceptionCause(StackTraceElement[] stackTrace) {
            this.setStackTrace(stackTrace);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

