/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.util.Objects;
import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.ValueAdapter;

public class StringValue
extends ValueAdapter {
    private final String val;

    public StringValue(String val) {
        if (val == null) {
            throw new IllegalArgumentException("Cannot construct StringValue from null");
        }
        this.val = val;
    }

    @Override
    public boolean isEmpty() {
        return this.val.isEmpty();
    }

    @Override
    public int size() {
        return this.val.length();
    }

    @Override
    public String asObject() {
        return this.asString();
    }

    @Override
    public String asString() {
        return this.val;
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.isAssignableFrom(String.class)) {
            return targetClass.cast(this.asString());
        }
        if (targetClass.isAssignableFrom(Character.TYPE) || targetClass.isAssignableFrom(Character.class)) {
            if (this.val.length() == 1) {
                return (T)Character.valueOf(this.val.charAt(0));
            }
            throw new LossyCoercion(this.type().name(), targetClass.getCanonicalName());
        }
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }

    @Override
    public String toString() {
        return String.format("\"%s\"", this.val.replace("\"", "\\\""));
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.STRING();
    }

    public Type boltValueType() {
        return Type.STRING;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValue that = (StringValue)o;
        return Objects.equals(this.val, that.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }
}

