/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Locale;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlHelper;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.messages.MessageUtil;

public class InvalidArgumentException
extends Neo4jException {
    @Deprecated
    public InvalidArgumentException(String message, Throwable cause) {
        super(message, cause);
    }

    public InvalidArgumentException(ErrorGqlStatusObject gqlStatusObject, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
    }

    @Deprecated
    public InvalidArgumentException(String message) {
        super(message);
    }

    public InvalidArgumentException(ErrorGqlStatusObject gqlStatusObject, String message) {
        super(gqlStatusObject, message);
    }

    public Status status() {
        return Status.Statement.ArgumentError;
    }

    public static InvalidArgumentException unknownNormalForm(String normalForm) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42001).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N49).withParam(GqlParams.StringParam.input, normalForm).build()).build();
        return new InvalidArgumentException(gql, "Unknown normal form. Valid values are: NFC, NFD, NFKC, NFKD.");
    }

    public static InvalidArgumentException incompleteSpatialValue(String crs, String mandatoryKeys, List<String> mandatoryKeysList) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N18).withParam(GqlParams.StringParam.crs, String.valueOf(crs)).withParam(GqlParams.ListParam.mapKeyList, mandatoryKeysList).build()).build();
        return new InvalidArgumentException(gql, String.format("A %s point must contain %s", crs, mandatoryKeys));
    }

    public static InvalidArgumentException invalidSpatialValueCombination() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N22).build()).build();
        return new InvalidArgumentException(gql, "Cannot specify both CRS and SRID");
    }

    public static InvalidArgumentException timezoneAndOffsetMismatch(String context, String offset, List<String> validOffsets, String matcherGroup) {
        ErrorGqlStatusObject gql = validOffsets.isEmpty() ? ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(offset)).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, String.valueOf(offset)).withParam(GqlParams.StringParam.context, context).build()).build() : ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withParam(GqlParams.StringParam.value, String.valueOf(offset)).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N04).withParam(GqlParams.StringParam.input, String.valueOf(offset)).withParam(GqlParams.StringParam.context, context).withParam(GqlParams.ListParam.inputList, validOffsets).build()).build();
        return new InvalidArgumentException(gql, "Timezone and offset do not match: " + matcherGroup);
    }

    public static InvalidArgumentException temporalSelectionConflict(String temporal1, String temporal2) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22007).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N14).withParam(GqlParams.StringParam.temporal1, temporal1).withParam(GqlParams.StringParam.temporal2, temporal2).build()).build();
        return new InvalidArgumentException(gql, String.format("%s cannot be selected together with %s.", temporal1, temporal2));
    }

    public static InvalidArgumentException invalidCoordinateNames() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N19).build()).build();
        return new InvalidArgumentException(gql, "A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
    }

    public static InvalidArgumentException pointWithWrongDimensions(int expectedDimension, int actualDimension) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22000).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N20).withParam(GqlParams.NumberParam.dim1, (Number)expectedDimension).withParam(GqlParams.NumberParam.value, (Number)actualDimension).withParam(GqlParams.NumberParam.dim2, (Number)actualDimension).build()).build();
        return new InvalidArgumentException(gql, String.format("Cannot create point with %dD coordinate reference system and %d coordinates. Please consider using equivalent %dD coordinate reference system", expectedDimension, actualDimension, actualDimension));
    }

    public static InvalidArgumentException bothAllowedAndDeniedDbs() {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N85).build();
        return new InvalidArgumentException(gql, "Can't specify both allowed and denied databases");
    }

    public static InvalidArgumentException invalidEncryptionVersion(String version, List<String> allowedVersions) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)version, (String)"encryption version", allowedVersions);
        IllegalArgumentException innerException = new IllegalArgumentException("The encryption version specified is not available.");
        return new InvalidArgumentException(gql, innerException.getMessage(), innerException);
    }

    public static InvalidArgumentException invalidURLScheme(String url, List<String> allowedSchemes) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)url, (String)"URL scheme", allowedSchemes);
        return new InvalidArgumentException(gql, MessageUtil.invalidScheme(url, allowedSchemes));
    }

    public static InvalidArgumentException insecureURLScheme(String url, List<String> allowedSchemes) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)url, (String)"URL scheme", allowedSchemes);
        return new InvalidArgumentException(gql, MessageUtil.insecureScheme(url, allowedSchemes));
    }

    public static InvalidArgumentException incorrectPasswordFormat() {
        IllegalArgumentException innerException = new IllegalArgumentException("Incorrect format of encrypted password. Correct format is '<encryption-version>,<hash>,<salt>'.");
        ErrorGqlStatusObject gql = GqlHelper.getGql42001_22N04((String)"*", (String)"password format", List.of("'<encryption-version>,<hash>,<salt>'"));
        return new InvalidArgumentException(gql, innerException.getMessage(), innerException);
    }

    public static InvalidArgumentException duplicateFieldNotAllowed(String key) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)key);
        return new InvalidArgumentException(gql, String.format("Duplicate field '%s' is not allowed.", key));
    }

    public static InvalidArgumentException duplicateField(String key) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)key);
        return new InvalidArgumentException(gql, String.format("Duplicate field '%s'", key));
    }

    public static InvalidArgumentException parseMapValue(String text) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)text);
        return new InvalidArgumentException(gql, String.format("Failed to parse map value: '%s'", text));
    }

    public static InvalidArgumentException setTimeZoneTwice(String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)value);
        return new InvalidArgumentException(gql, "Cannot set timezone twice");
    }

    public static InvalidArgumentException unsupportedHeader(String key, String value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)key);
        return new InvalidArgumentException(gql, "Unsupported header field: " + value);
    }

    public static InvalidArgumentException alterRemoteAliasToLocal(String alias) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N91).withParam(GqlParams.StringParam.alias, alias).build();
        return new InvalidArgumentException(gql, String.format("Failed to alter the specified database alias '%s': alter a local alias to a remote alias is not supported.", alias));
    }

    public static InvalidArgumentException alterLocalAliasToRemote(String alias) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N91).withParam(GqlParams.StringParam.alias, alias).build();
        return new InvalidArgumentException(gql, String.format("Failed to alter the specified database alias '%s': alter a remote alias to a local alias is not supported.", alias));
    }

    public static InvalidArgumentException renameEntityNotFound(ErrorGqlStatusObject gql, String entity, String fromName, String toName) {
        return new InvalidArgumentException(gql, String.format("Failed to rename the specified %s '%s' to ", entity, fromName) + String.format("'%s': The %s '%s' does not exist.", toName, entity, fromName));
    }

    public static InvalidArgumentException renameEntityAlreadyExists(ErrorGqlStatusObject gql, String entity, String fromName, String toName, Throwable cause) {
        return new InvalidArgumentException(gql, String.format("Failed to rename the specified %s '%s' to ", entity.toLowerCase(Locale.ROOT), fromName) + String.format("'%s': %s '%s' already exists.", toName, entity, toName), cause);
    }

    public static InvalidArgumentException oldPasswordEqualsNew(String user, Boolean onSelf) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, "***").withParam(GqlParams.StringParam.context, user + " password").withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N89).build()).build();
        String msg = onSelf != false ? String.format("User '%s' failed to alter their own password: Old password and new password cannot be the same.", user) : String.format("Failed to alter the specified user '%s': Old password and new password cannot be the same.", user);
        return new InvalidArgumentException(gql, msg);
    }

    public static InvalidArgumentException shortPassword(int minLength) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, "***").withParam(GqlParams.StringParam.context, "password").withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N85).withParam(GqlParams.NumberParam.lower, (Number)minLength).build()).build();
        return new InvalidArgumentException(gql, String.format("A password must be at least %s characters.", minLength));
    }

    public static InvalidArgumentException parameterizedDbWildcards(String syntax, String messageStart) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N86).withParam(GqlParams.StringParam.syntax, syntax).build();
        return new InvalidArgumentException(gql, String.format("%s: Parameterized database and graph names do not support wildcards.", messageStart));
    }

    public static InvalidArgumentException missingMandatoryAuthClause(String clause, String authProvider, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42N97).withParam(GqlParams.StringParam.clause, clause).withParam(GqlParams.StringParam.auth, authProvider).build();
        return new InvalidArgumentException(gql, legacyMessage);
    }

    public static InvalidArgumentException couldNotGetPassword() {
        String msg = "Could not get password name field from password expression.";
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentException.class.getSimpleName(), (String)msg);
        return new InvalidArgumentException(gql, msg);
    }

    public static InvalidArgumentException remoteDatabaseUrl() {
        String msg = "Could not validate remote database alias url.";
        ErrorGqlStatusObject gql = GqlHelper.get50N00((String)InvalidArgumentException.class.getSimpleName(), (String)msg);
        return new InvalidArgumentException(gql, msg);
    }

    public static InvalidArgumentException alterMissingUser(String username) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42002_42N09((String)username);
        return new InvalidArgumentException(gql, String.format("Failed to alter the specified user '%s': User does not exist.", username));
    }

    public static InvalidArgumentException roleMissingUser(String role, String username, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.getGql42002_42N09((String)username);
        return new InvalidArgumentException(gql, String.format("Failed to grant role '%s' to user '%s': User does not exist.", role, username), cause);
    }

    public static InvalidArgumentException compositeAlias(String operationType, String alias, String dbName) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_42NA6).build();
        String msg = String.format("Failed to %s the specified database alias '%s': ", operationType, alias) + String.format("Database '%s' is composite.", dbName);
        return new InvalidArgumentException(gql, msg);
    }

    public static InvalidArgumentException dbNameTooLong(String dbName) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N05_22N84((String)dbName, (String)"database name", (int)65534);
        return new InvalidArgumentException(gql, "The provided target database name is to long, maximum characters are 65534.");
    }

    public static InvalidArgumentException aliasTooLong(String alias) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N05_22N84((String)alias, (String)"alias", (int)65534);
        return new InvalidArgumentException(gql, "The provided alias is to long, maximum characters are 65534.");
    }

    public static InvalidArgumentException tooManySeeders(int numberOfSeedingServers, int numberOfAllocations) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N18).withParam(GqlParams.NumberParam.countSeeders, (Number)numberOfSeedingServers).withParam(GqlParams.NumberParam.countAllocs, (Number)numberOfAllocations).build()).build();
        return new InvalidArgumentException(gql, String.format("The number of seeding servers '%s' is larger than the defined number of allocations '%s'.", numberOfSeedingServers, numberOfAllocations));
    }

    public static InvalidArgumentException noSuchSeeder(String serverId) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N16).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_52N19).withParam(GqlParams.StringParam.server, serverId).build()).build();
        return new InvalidArgumentException(gql, String.format("The specified seeding server with id '%s' could not be found.", serverId));
    }

    public static InvalidArgumentException topologyOutOfRange(String serverType, int constrainedServers, String allocationType, int desiredAllocations) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22003).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N56).withParam(GqlParams.StringParam.serverType, serverType).withParam(GqlParams.NumberParam.count1, (Number)constrainedServers).withParam(GqlParams.StringParam.allocType, allocationType).withParam(GqlParams.NumberParam.count2, (Number)desiredAllocations).build()).build();
        Object formattedServerType = serverType.isEmpty() ? "" : " " + serverType;
        Object formattedAllocationType = allocationType.isEmpty() ? "" : " " + allocationType;
        return new InvalidArgumentException(gql, String.format("The number of%s seeding servers '%s', is larger than the desired number of%s allocations '%s'.", formattedServerType, constrainedServers, formattedAllocationType, desiredAllocations));
    }

    public static InvalidArgumentException notAValidCidrIp(String wrongIp, String legacyMessage, Throwable cause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, wrongIp).withParam(GqlParams.StringParam.context, "CIDR IP").withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N88).withParam(GqlParams.StringParam.input, wrongIp).build()).build();
        return new InvalidArgumentException(gql, legacyMessage, cause);
    }

    public static InvalidArgumentException mustSpecifyField(String mustAssign) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)mustAssign);
        return new InvalidArgumentException(gql, mustAssign + " must be specified");
    }

    public static InvalidArgumentException cannotReassign(String newValue, String field) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)newValue);
        return new InvalidArgumentException(gql, "cannot re-assign " + field);
    }

    public static InvalidArgumentException cannotAssignNonStringTimezone(String value, String field, String prettyValue) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22007).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N27).withParam(GqlParams.StringParam.input, prettyValue).withParam(GqlParams.StringParam.variable, "timezone").withParam(GqlParams.ListParam.valueTypeList, List.of("STRING")).build()).build();
        return new InvalidArgumentException(gql, String.format("Cannot assign %s to field %s", value, field));
    }

    public static InvalidArgumentException cannotAssignPointField(String value, String field, String prettyValue, List<String> expectedTypes) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22G03).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N27).withParam(GqlParams.StringParam.input, prettyValue).withParam(GqlParams.StringParam.variable, "coordinate " + field.toLowerCase(Locale.ROOT)).withParam(GqlParams.ListParam.valueTypeList, expectedTypes).build()).build();
        return new InvalidArgumentException(gql, String.format("Cannot assign %s to field %s", value, field));
    }

    public static InvalidArgumentException assignTimezoneTwice(String timezone) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)timezone);
        return new InvalidArgumentException(gql, "Cannot assign timezone twice.");
    }

    public static InvalidArgumentException noSuchTemporalField(String field) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)field);
        return new InvalidArgumentException(gql, "No such field: " + field);
    }

    public static InvalidArgumentException noSuchPointField(String field) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N11).withParam(GqlParams.StringParam.input, field).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N04).withParam(GqlParams.StringParam.input, field).withParam(GqlParams.StringParam.context, "coordinate").withParam(GqlParams.ListParam.inputList, List.of("x", "y", "z", "longitude", "latitude", "height", "crs", "srid")).build()).build();
        return new InvalidArgumentException(gql, "No such field: " + field);
    }

    public static InvalidArgumentException cannotSpecifyWithout(String value, String missing) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N12((String)value);
        return new InvalidArgumentException(gql, value + " cannot be specified without " + missing);
    }

    public static InvalidArgumentException invalidMillisecondValue(long upper, long value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)"Millisecond", (String)"INTEGER", (Number)0, (Number)upper, (Object)value);
        return new InvalidArgumentException(gql, "Invalid value for Millisecond: " + value);
    }

    public static InvalidArgumentException invalidMicrosecondValue(long upper, long value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)"Microsecond", (String)"INTEGER", (Number)0, (Number)upper, (Object)value);
        return new InvalidArgumentException(gql, "Invalid value for Microsecond: " + value);
    }

    public static InvalidArgumentException invalidNanosecondValue(long upper, long value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)"Nanosecond", (String)"INTEGER", (Number)0, (Number)upper, (Object)value);
        return new InvalidArgumentException(gql, "Invalid value for Nanosecond: " + value);
    }

    public static InvalidArgumentException invalidNanosecond(long upper, long value) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)"Nanosecond", (String)"INTEGER", (Number)0, (Number)upper, (Object)value);
        return new InvalidArgumentException(gql, "Invalid nanosecond: " + value);
    }

    public static InvalidArgumentException zeroStepRange() {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N03((String)"range", (String)"step", (String)"INTEGER", (Number)1, (Number)Long.MAX_VALUE, (Object)String.valueOf(0));
        return new InvalidArgumentException(gql, "Step argument to 'range()' cannot be zero");
    }

    public static InvalidArgumentException negRoundPrecision(int precision) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22N38_22N03((String)"round", (String)"precision", (String)"INTEGER", (Number)0, (Number)Long.MAX_VALUE, (Object)precision);
        return new InvalidArgumentException(gql, "Precision argument to 'round()' cannot be negative");
    }

    public static InvalidArgumentException tooManyWeeksThisYear(int week, int year) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)("week of year " + year), (String)"INTEGER", (Number)1, (Number)52, (Object)week);
        return new InvalidArgumentException(gql, String.format("Year %d does not contain %d weeks.", year, week));
    }

    public static InvalidArgumentException temporalOutOfRange(ChronoUnit unit, long value) {
        String msg;
        return new InvalidArgumentException(switch (unit) {
            case ChronoUnit.MONTHS -> {
                msg = "months is out of range: " + value;
                yield GqlHelper.getGql22007_22N03((String)"month", (String)"INTEGER", (Number)1, (Number)12, (Object)value);
            }
            case ChronoUnit.DAYS -> {
                msg = "days is out of range: " + value;
                yield GqlHelper.getGql22007_22N03((String)"day", (String)"INTEGER", (Number)1, (Number)31, (Object)value);
            }
            case ChronoUnit.HOURS -> {
                msg = "hours out of range: " + value;
                yield GqlHelper.getGql22007_22N03((String)"hours", (String)"INTEGER", (Number)0, (Number)24, (Object)value);
            }
            case ChronoUnit.MINUTES -> {
                msg = "minutes out of range: " + value;
                yield GqlHelper.getGql22007_22N03((String)"minutes", (String)"INTEGER", (Number)0, (Number)60, (Object)value);
            }
            case ChronoUnit.SECONDS -> {
                msg = "seconds out of range: " + value;
                yield GqlHelper.getGql22007_22N03((String)"seconds", (String)"INTEGER", (Number)0, (Number)60, (Object)value);
            }
            default -> {
                msg = unit.name().toLowerCase() + "out of range: " + value;
                yield GqlHelper.getGql22007_22N03((String)unit.name().toLowerCase(), (String)"INTEGER", (Number)-1, (Number)-1, (Object)value);
            }
        }, msg);
    }

    public static InvalidArgumentException only91DaysInQuarter2(int year, int quarterDay) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)("Day of Quarter 2 of year " + year), (String)"INTEGER", (Number)1, (Number)91, (Object)quarterDay);
        return new InvalidArgumentException(gql, "Quarter 2 only has 91 days.");
    }

    public static InvalidArgumentException only90Or91DaysInQuarter1(int year, int quarterDay, int dayLimit) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N03((String)("Day of Quarter 1 of year " + year), (String)"INTEGER", (Number)1, (Number)dayLimit, (Object)quarterDay);
        return new InvalidArgumentException(gql, String.format("Quarter 1 of %d only has %d days.", year, dayLimit));
    }

    public static InvalidArgumentException invalidValuePrefixSuffix(long minValue, String actualValue, String prefix, String suffix, String actualValuePretty) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003_22N03((String)"value", (String)"INTEGER", (Number)minValue, (Number)Long.MAX_VALUE, (String)actualValuePretty);
        return new InvalidArgumentException(gql, String.format("%s: Invalid input. '%s' is not a valid value.%s", prefix, actualValue, suffix));
    }

    public static InvalidArgumentException invalidDoubleValuePrefixSuffix(String actualValue, String prefix, String suffix, String actualValuePretty) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)actualValuePretty, List.of("INTEGER"), (String)"FLOAT");
        return new InvalidArgumentException(gql, String.format("%s: Invalid input. '%s' is not a valid value.%s", prefix, actualValue, suffix));
    }

    public static InvalidArgumentException countNotPosInt(Number actualCount) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003_22N03((String)"value", (String)"INTEGER", (Number)0, (Number)Long.MAX_VALUE, (String)String.valueOf(actualCount));
        return new InvalidArgumentException(gql, String.format("Invalid input. '%s' is not a valid value. Must be a non-negative integer.", actualCount));
    }

    public static InvalidArgumentException countDoubleNotPosInt(double actualCount) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)String.valueOf(actualCount), List.of("INTEGER"), (String)"FLOAT");
        return new InvalidArgumentException(gql, String.format("Invalid input. '%s' is not a valid value. Must be a non-negative integer.", actualCount));
    }

    public static InvalidArgumentException invalidPercentage(double faultyPercentage) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003_22N03((String)"percentage", (String)"FLOAT", (Number)0, (Number)1, (String)String.valueOf(faultyPercentage));
        return new InvalidArgumentException(gql, String.format("Invalid input '%s' is not a valid argument, must be a number in the range 0.0 to 1.0", faultyPercentage));
    }

    public static InvalidArgumentException cannotConstructTemporal(String temporal, String got, String gotPretty) {
        String cypherType = switch (temporal) {
            case "date" -> "DATE";
            case "time" -> "ZONED TIME";
            case "date time" -> "ZONED DATETIME";
            case "local date time" -> "LOCAL DATETIME";
            case "local time" -> "LOCAL TIME";
            default -> temporal;
        };
        ErrorGqlStatusObject gql = GqlHelper.getGql22007_22N25((String)cypherType, (String)gotPretty);
        return new InvalidArgumentException(gql, String.format("Cannot construct %s from: %s", temporal, got));
    }

    public static InvalidArgumentException needIntegerOrFloat(String gotPretty, String gotType) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22G03_22N01((String)gotPretty, List.of("INTEGER", "FLOAT"), (String)gotType);
        return new InvalidArgumentException(gql, "Factor must be either integer of floating point number.");
    }

    public static InvalidArgumentException inputContainsInvalidCharacters(String invalidInput, String context, String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N05).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N82).withParam(GqlParams.StringParam.input, invalidInput).withParam(GqlParams.StringParam.context, context).build()).build();
        return new InvalidArgumentException(gql, legacyMessage);
    }

    public static InvalidArgumentException failedConvertFunction(String function, Throwable cause) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22000_22N11((String)function);
        return new InvalidArgumentException(gql, cause.getMessage(), cause);
    }

    public static InvalidArgumentException listTooLarge(long size, long maxSize) {
        ErrorGqlStatusObject gql = GqlHelper.getGql22003_22N03((String)"list size", (String)"INTEGER", (Number)0, (Number)maxSize, (String)String.valueOf(size));
        return new InvalidArgumentException(gql, String.format("Cannot populate list values larger than %d elements. Requested size: %d", maxSize, size));
    }
}

