/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.Objects;
import java.util.UUID;
import org.neo4j.util.Id;

public class DatabaseId {
    public static final DatabaseId SYSTEM_DATABASE_ID = new DatabaseId(new UUID(0L, 1L));
    private final Id id;

    DatabaseId(UUID uuid) {
        Objects.requireNonNull(uuid, "Database UUID should be not null.");
        this.id = new Id(uuid);
    }

    public UUID uuid() {
        return this.id.uuid();
    }

    Id id() {
        return this.id;
    }

    public boolean isSystemDatabase() {
        return SYSTEM_DATABASE_ID.equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseId that = (DatabaseId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "DatabaseId{" + String.valueOf(this.id) + "}";
    }
}

