/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class HeapTrackingArrayDeque<E>
implements Deque<E>,
AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingArrayDeque.class);
    private static final int DEFAULT_SIZE = 16;
    private final MemoryTracker memoryTracker;
    private long trackedSize;
    private Object[] elements;
    private int head;
    private int tail;

    public static <T> HeapTrackingArrayDeque<T> newArrayDeque(MemoryTracker memoryTracker) {
        return HeapTrackingArrayDeque.newArrayDeque(16, memoryTracker);
    }

    public static <T> HeapTrackingArrayDeque<T> newArrayDeque(int numElements, MemoryTracker memoryTracker) {
        int actualNumElements = numElements < 1 ? 1 : (numElements == Integer.MAX_VALUE ? Integer.MAX_VALUE : numElements + 1);
        long trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)actualNumElements);
        memoryTracker.allocateHeap(SHALLOW_SIZE + trackedSize);
        return new HeapTrackingArrayDeque(actualNumElements, memoryTracker, trackedSize);
    }

    private HeapTrackingArrayDeque(int numElements, MemoryTracker memoryTracker, long trackedSize) {
        this.elements = new Object[numElements];
        this.memoryTracker = memoryTracker;
        this.trackedSize = trackedSize;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] es = this.elements;
        this.head = HeapTrackingArrayDeque.dec(this.head, es.length);
        es[this.head] = e;
        if (this.head == this.tail) {
            this.grow(1);
        }
    }

    @Override
    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] es = this.elements;
        es[this.tail] = e;
        this.tail = HeapTrackingArrayDeque.inc(this.tail, es.length);
        if (this.head == this.tail) {
            this.grow(1);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int s = this.size();
        int needed = s + c.size() + 1 - this.elements.length;
        if (needed > 0) {
            this.grow(needed);
        }
        this.copyElements(c);
        return this.size() > s;
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        E e = this.pollFirst();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E pollFirst() {
        Object[] es = this.elements;
        int h = this.head;
        E e = HeapTrackingArrayDeque.elementAt(this.elements, h);
        if (e != null) {
            es[h] = null;
            this.head = HeapTrackingArrayDeque.inc(h, es.length);
        }
        return e;
    }

    @Override
    public E pollLast() {
        Object[] es = this.elements;
        int t = HeapTrackingArrayDeque.dec(this.tail, es.length);
        E e = HeapTrackingArrayDeque.elementAt(this.elements, t);
        if (e != null) {
            this.tail = t;
            es[this.tail] = null;
        }
        return e;
    }

    @Override
    public E getFirst() {
        E e = HeapTrackingArrayDeque.elementAt(this.elements, this.head);
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        Object[] es = this.elements;
        E e = HeapTrackingArrayDeque.elementAt(es, HeapTrackingArrayDeque.dec(this.tail, es.length));
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E peekFirst() {
        return HeapTrackingArrayDeque.elementAt(this.elements, this.head);
    }

    @Override
    public E peekLast() {
        Object[] es = this.elements;
        return HeapTrackingArrayDeque.elementAt(this.elements, HeapTrackingArrayDeque.dec(this.tail, es.length));
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        if (o != null) {
            int to;
            Object[] es = this.elements;
            int i = this.head;
            int end = this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    if (o.equals(es[i])) {
                        this.delete(i);
                        return true;
                    }
                    ++i;
                    continue;
                }
                if (to == end) break;
                i = 0;
                to = end;
            }
        }
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o != null) {
            Object[] es = this.elements;
            int i = this.tail;
            int end = this.head;
            int to = i >= end ? end : 0;
            while (true) {
                --i;
                while (i > to - 1) {
                    if (o.equals(es[i])) {
                        this.delete(i);
                        return true;
                    }
                    --i;
                }
                if (to == end) break;
                i = es.length;
                to = end;
            }
        }
        return false;
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public int size() {
        return HeapTrackingArrayDeque.sub(this.tail, this.head, this.elements.length);
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<E> iterator() {
        return new DeqIterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        int to;
        Objects.requireNonNull(action);
        Object[] es = this.elements;
        int i = this.head;
        int end = this.tail;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                action.accept(HeapTrackingArrayDeque.elementAt(es, i));
                ++i;
                continue;
            }
            if (to == end) {
                if (end == this.tail) break;
                throw new ConcurrentModificationException();
            }
            i = 0;
            to = end;
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        Objects.requireNonNull(filter);
        return this.bulkRemove(filter);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(c::contains);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        return this.bulkRemove(e -> !c.contains(e));
    }

    static int inc(int i, int modulus) {
        if (++i >= modulus) {
            i = 0;
        }
        return i;
    }

    static int dec(int i, int modulus) {
        if (--i < 0) {
            i = modulus - 1;
        }
        return i;
    }

    static int sub(int i, int j, int modulus) {
        if ((i -= j) < 0) {
            i += modulus;
        }
        return i;
    }

    static <E> E elementAt(Object[] es, int i) {
        return (E)es[i];
    }

    static <E> E nonNullElementAt(Object[] es, int i) {
        Object e = es[i];
        if (e == null) {
            throw new ConcurrentModificationException();
        }
        return (E)e;
    }

    boolean delete(int i) {
        int t;
        int back;
        int h = this.head;
        Object[] es = this.elements;
        int capacity = es.length;
        int front = HeapTrackingArrayDeque.sub(i, h, capacity);
        if (front < (back = HeapTrackingArrayDeque.sub(t = this.tail, i, capacity) - 1)) {
            if (h <= i) {
                System.arraycopy(es, h, es, h + 1, front);
            } else {
                System.arraycopy(es, 0, es, 1, i);
                es[0] = es[capacity - 1];
                System.arraycopy(es, h, es, h + 1, front - (i + 1));
            }
            es[h] = null;
            this.head = HeapTrackingArrayDeque.inc(h, capacity);
            return false;
        }
        this.tail = HeapTrackingArrayDeque.dec(t, capacity);
        if (i <= this.tail) {
            System.arraycopy(es, i + 1, es, i, back);
        } else {
            System.arraycopy(es, i + 1, es, i, capacity - (i + 1));
            es[capacity - 1] = es[0];
            System.arraycopy(es, 1, es, 0, t - 1);
        }
        es[this.tail] = null;
        return true;
    }

    private void copyElements(Collection<? extends E> c) {
        c.forEach(this::addLast);
    }

    private boolean bulkRemove(Predicate<? super E> filter) {
        int to;
        Object[] es = this.elements;
        int i = this.head;
        int end = this.tail;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                if (filter.test(HeapTrackingArrayDeque.elementAt(es, i))) {
                    return this.bulkRemoveModified(filter, i);
                }
                ++i;
                continue;
            }
            if (to == end) {
                if (end == this.tail) break;
                throw new ConcurrentModificationException();
            }
            i = 0;
            to = end;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            int to;
            Object[] es = this.elements;
            int i = this.head;
            int end = this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    if (o.equals(es[i])) {
                        return true;
                    }
                    ++i;
                    continue;
                }
                if (to == end) break;
                i = 0;
                to = end;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public void clear() {
        HeapTrackingArrayDeque.circularClear(this.elements, this.head, this.tail);
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[].class);
    }

    private <T> T[] toArray(Class<T[]> klazz) {
        T[] a;
        int tail;
        Object[] es = this.elements;
        int head = this.head;
        int end = tail + (head <= (tail = this.tail) ? 0 : es.length);
        if (end >= 0) {
            a = Arrays.copyOfRange(es, head, end, klazz);
        } else {
            a = Arrays.copyOfRange(es, 0, end - head, klazz);
            System.arraycopy(es, head, a, 0, es.length - head);
        }
        if (end != tail) {
            System.arraycopy(es, 0, a, es.length - head, tail);
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (size > a.length) {
            return this.toArray(a.getClass());
        }
        Object[] es = this.elements;
        int i = this.head;
        int j = 0;
        int len = Math.min(size, es.length - i);
        while (true) {
            System.arraycopy(es, i, a, j, len);
            if ((j += len) == size) break;
            i = 0;
            len = this.tail;
        }
        if (size < a.length) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public void close() {
        if (this.elements != null) {
            this.memoryTracker.releaseHeap(this.trackedSize + SHALLOW_SIZE);
            this.elements = null;
        }
    }

    public Iterator<E> autoClosingIterator() {
        return new DeqIterator(){

            @Override
            void done() {
                HeapTrackingArrayDeque.this.close();
            }
        };
    }

    private void grow(int needed) {
        int newCapacity;
        int jump;
        int oldCapacity = this.elements.length;
        int n = jump = oldCapacity < 64 ? oldCapacity + 2 : oldCapacity >> 1;
        if (jump < needed || (newCapacity = oldCapacity + jump) - 0x7FFFFFF7 > 0) {
            newCapacity = this.newCapacity(needed, jump);
        }
        long oldHeapUsage = this.trackedSize;
        this.trackedSize = HeapEstimator.shallowSizeOfObjectArray((int)newCapacity);
        this.memoryTracker.allocateHeap(this.trackedSize);
        this.elements = Arrays.copyOf(this.elements, newCapacity);
        Object[] es = this.elements;
        this.memoryTracker.releaseHeap(oldHeapUsage);
        if (this.tail < this.head || this.tail == this.head && es[this.head] != null) {
            int newSpace = newCapacity - oldCapacity;
            System.arraycopy(es, this.head, es, this.head + newSpace, oldCapacity - this.head);
            int to = this.head += newSpace;
            for (int i = this.head; i < to; ++i) {
                es[i] = null;
            }
        }
    }

    private int newCapacity(int needed, int jump) {
        int oldCapacity = this.elements.length;
        int minCapacity = oldCapacity + needed;
        if (minCapacity - 0x7FFFFFF7 > 0) {
            if (minCapacity < 0) {
                throw new IllegalStateException("Sorry, deque too big");
            }
            return Integer.MAX_VALUE;
        }
        if (needed > jump) {
            return minCapacity;
        }
        return oldCapacity + jump - 0x7FFFFFF7 < 0 ? oldCapacity + jump : 0x7FFFFFF7;
    }

    private static void circularClear(Object[] es, int i, int end) {
        int to;
        int n = to = i <= end ? end : es.length;
        while (true) {
            if (i < to) {
                es[i] = null;
                ++i;
                continue;
            }
            if (to == end) break;
            i = 0;
            to = end;
        }
    }

    private static long[] nBits(int n) {
        return new long[(n - 1 >> 6) + 1];
    }

    private static void setBit(long[] bits, int i) {
        int n = i >> 6;
        bits[n] = bits[n] | 1L << i;
    }

    private static boolean isClear(long[] bits, int i) {
        return (bits[i >> 6] & 1L << i) == 0L;
    }

    private boolean bulkRemoveModified(Predicate<? super E> filter, int beg) {
        Object[] es = this.elements;
        int capacity = es.length;
        int end = this.tail;
        long[] deathRow = HeapTrackingArrayDeque.nBits(HeapTrackingArrayDeque.sub(end, beg, capacity));
        deathRow[0] = 1L;
        int i = beg + 1;
        int to = i <= end ? end : es.length;
        int k = beg;
        while (true) {
            if (i < to) {
                if (filter.test(HeapTrackingArrayDeque.elementAt(es, i))) {
                    HeapTrackingArrayDeque.setBit(deathRow, i - k);
                }
                ++i;
                continue;
            }
            if (to == end) break;
            i = 0;
            to = end;
            k -= capacity;
        }
        int w = beg;
        int i2 = beg + 1;
        int to2 = i2 <= end ? end : es.length;
        int k2 = beg;
        while (true) {
            if (i2 < to2) {
                if (HeapTrackingArrayDeque.isClear(deathRow, i2 - k2)) {
                    es[w++] = es[i2];
                }
                ++i2;
                continue;
            }
            if (to2 == end) break;
            to2 = end;
            k2 -= capacity;
            for (i2 = 0; i2 < to2 && w < capacity; ++i2) {
                if (!HeapTrackingArrayDeque.isClear(deathRow, i2 - k2)) continue;
                es[w++] = es[i2];
            }
            if (i2 >= to2) {
                if (w != capacity) break;
                w = 0;
                break;
            }
            w = 0;
        }
        if (end != this.tail) {
            throw new ConcurrentModificationException();
        }
        this.tail = w;
        HeapTrackingArrayDeque.circularClear(es, this.tail, end);
        return true;
    }

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = HeapTrackingArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = HeapTrackingArrayDeque.this.head;
        }

        void done() {
        }

        @Override
        public final boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.remaining > 0;
            if (!hasNext) {
                this.done();
            }
            return hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object[] es = HeapTrackingArrayDeque.this.elements;
            Object e = HeapTrackingArrayDeque.nonNullElementAt(es, this.cursor);
            this.lastRet = this.cursor;
            this.cursor = HeapTrackingArrayDeque.inc(this.lastRet, es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = HeapTrackingArrayDeque.dec(this.cursor, HeapTrackingArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(HeapTrackingArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = HeapTrackingArrayDeque.this.elements;
            if (es[this.cursor] == null || HeapTrackingArrayDeque.sub(HeapTrackingArrayDeque.this.tail, this.cursor, es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = HeapTrackingArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(HeapTrackingArrayDeque.elementAt(es, i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != HeapTrackingArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = HeapTrackingArrayDeque.dec(end, es.length);
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = HeapTrackingArrayDeque.dec(HeapTrackingArrayDeque.this.tail, HeapTrackingArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = HeapTrackingArrayDeque.this.elements;
            Object e = HeapTrackingArrayDeque.nonNullElementAt(es, this.cursor);
            this.lastRet = this.cursor;
            this.cursor = HeapTrackingArrayDeque.dec(this.lastRet, es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = HeapTrackingArrayDeque.inc(this.cursor, HeapTrackingArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = HeapTrackingArrayDeque.this.elements;
            if (es[this.cursor] == null || HeapTrackingArrayDeque.sub(this.cursor, HeapTrackingArrayDeque.this.head, es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = HeapTrackingArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(HeapTrackingArrayDeque.elementAt(es, i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != HeapTrackingArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }
}

