/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.shell.commands.ClientConfig;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
record Metric(String metricName, String displayName, Function<Value, Value> mapper, boolean dbType) {
    String fullName(ClientConfig config, String database) {
        StringBuilder builder = new StringBuilder(config.metricsDomain()).append(":name=").append(config.serverMetricsPrefix());
        Boolean namespacesEnables = config.namespacesEnabled().orElse(true);
        if (this.dbType) {
            if (namespacesEnables.booleanValue()) {
                builder.append(".database");
            }
            builder.append(".").append(database);
        } else if (namespacesEnables.booleanValue()) {
            builder.append(".dbms");
        }
        return builder.append(".").append(this.metricName).toString();
    }

    static Metric db(String metricName, String displayName) {
        return new Metric(metricName, displayName, Function.identity(), true);
    }

    static Metric dbms(String metricName, String displayName) {
        return new Metric(metricName, displayName, Function.identity(), false);
    }
}

