/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralArray;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberArray;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public interface ValueMapper<Base> {
    public Base mapPath(VirtualPathValue var1);

    public Base mapNode(VirtualNodeValue var1);

    public Base mapRelationship(VirtualRelationshipValue var1);

    public Base mapMap(MapValue var1);

    public Base mapNoValue();

    public Base mapSequence(SequenceValue var1);

    public Base mapText(TextValue var1);

    default public Base mapString(StringValue value) {
        return this.mapText(value);
    }

    default public Base mapTextArray(TextArray value) {
        return this.mapSequence(value);
    }

    default public Base mapStringArray(StringArray value) {
        return this.mapTextArray(value);
    }

    default public Base mapChar(CharValue value) {
        return this.mapText(value);
    }

    default public Base mapCharArray(CharArray value) {
        return this.mapTextArray(value);
    }

    public Base mapBoolean(BooleanValue var1);

    default public Base mapBooleanArray(BooleanArray value) {
        return this.mapSequence(value);
    }

    public Base mapNumber(NumberValue var1);

    default public Base mapNumberArray(NumberArray value) {
        return this.mapSequence(value);
    }

    default public Base mapIntegral(IntegralValue value) {
        return this.mapNumber(value);
    }

    default public Base mapIntegralArray(IntegralArray value) {
        return this.mapNumberArray(value);
    }

    default public Base mapByte(ByteValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapByteArray(ByteArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapShort(ShortValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapShortArray(ShortArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapInt(IntValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapIntArray(IntArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapLong(LongValue value) {
        return this.mapIntegral(value);
    }

    default public Base mapLongArray(LongArray value) {
        return this.mapIntegralArray(value);
    }

    default public Base mapFloatingPoint(FloatingPointValue value) {
        return this.mapNumber(value);
    }

    default public Base mapFloatingPointArray(FloatingPointArray value) {
        return this.mapNumberArray(value);
    }

    default public Base mapDouble(DoubleValue value) {
        return this.mapFloatingPoint(value);
    }

    default public Base mapDoubleArray(DoubleArray value) {
        return this.mapFloatingPointArray(value);
    }

    default public Base mapFloat(FloatValue value) {
        return this.mapFloatingPoint(value);
    }

    default public Base mapFloatArray(FloatArray value) {
        return this.mapFloatingPointArray(value);
    }

    public Base mapDateTime(DateTimeValue var1);

    public Base mapLocalDateTime(LocalDateTimeValue var1);

    public Base mapDate(DateValue var1);

    public Base mapTime(TimeValue var1);

    public Base mapLocalTime(LocalTimeValue var1);

    public Base mapDuration(DurationValue var1);

    public Base mapPoint(PointValue var1);

    default public Base mapPointArray(PointArray value) {
        return this.mapSequence(value);
    }

    default public Base mapDateTimeArray(DateTimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapLocalDateTimeArray(LocalDateTimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapLocalTimeArray(LocalTimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapTimeArray(TimeArray value) {
        return this.mapSequence(value);
    }

    default public Base mapDateArray(DateArray value) {
        return this.mapSequence(value);
    }

    default public Base mapDurationArray(DurationArray value) {
        return this.mapSequence(value);
    }

    public static abstract class JavaMapper
    implements ValueMapper<Object> {
        @Override
        public Object mapNoValue() {
            return null;
        }

        @Override
        public Object mapMap(MapValue value) {
            HashMap map = new HashMap(value.size());
            value.foreach((k, v) -> map.put(k, v.map(this)));
            return map;
        }

        @Override
        public List<?> mapSequence(SequenceValue value) {
            int size = value.intSize();
            ArrayList<Object> list = new ArrayList<Object>(size);
            if (value.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                for (int i = 0; i < size; ++i) {
                    list.add(value.value(i).map(this));
                }
            } else {
                value.forEach(v -> list.add(v.map(this)));
            }
            return list;
        }

        @Override
        public Character mapChar(CharValue value) {
            return Character.valueOf(value.value());
        }

        @Override
        public String mapText(TextValue value) {
            return value.stringValue();
        }

        @Override
        public String[] mapStringArray(StringArray value) {
            return value.asObjectCopy();
        }

        @Override
        public char[] mapCharArray(CharArray value) {
            return value.asObjectCopy();
        }

        @Override
        public Boolean mapBoolean(BooleanValue value) {
            return value.booleanValue();
        }

        @Override
        public boolean[] mapBooleanArray(BooleanArray value) {
            return value.asObjectCopy();
        }

        @Override
        public Number mapNumber(NumberValue value) {
            return value.asObject();
        }

        @Override
        public byte[] mapByteArray(ByteArray value) {
            return value.asObjectCopy();
        }

        @Override
        public short[] mapShortArray(ShortArray value) {
            return value.asObjectCopy();
        }

        @Override
        public int[] mapIntArray(IntArray value) {
            return value.asObjectCopy();
        }

        @Override
        public long[] mapLongArray(LongArray value) {
            return value.asObjectCopy();
        }

        @Override
        public float[] mapFloatArray(FloatArray value) {
            return value.asObjectCopy();
        }

        @Override
        public double[] mapDoubleArray(DoubleArray value) {
            return value.asObjectCopy();
        }

        @Override
        public ZonedDateTime mapDateTime(DateTimeValue value) {
            return (ZonedDateTime)value.asObjectCopy();
        }

        @Override
        public Number mapDouble(DoubleValue value) {
            return value.doubleValue();
        }

        @Override
        public Number mapLong(LongValue value) {
            return value.longValue();
        }

        @Override
        public LocalDateTime mapLocalDateTime(LocalDateTimeValue value) {
            return (LocalDateTime)value.asObjectCopy();
        }

        @Override
        public LocalDate mapDate(DateValue value) {
            return (LocalDate)value.asObjectCopy();
        }

        @Override
        public OffsetTime mapTime(TimeValue value) {
            return (OffsetTime)value.asObjectCopy();
        }

        @Override
        public LocalTime mapLocalTime(LocalTimeValue value) {
            return (LocalTime)value.asObjectCopy();
        }

        @Override
        public TemporalAmount mapDuration(DurationValue value) {
            return value.asObjectCopy();
        }

        @Override
        public Point mapPoint(PointValue value) {
            return value.asObjectCopy();
        }
    }
}

