/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.time.zone.ZoneRulesException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.TemporalParseException;
import org.neo4j.exceptions.UnsupportedTemporalUnitException;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.StructureBuilder;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.CSVHeaderInformation;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.TimeZones;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class DateTimeValue
extends TemporalValue<ZonedDateTime, DateTimeValue> {
    private static final long INSTANCE_SIZE = HeapEstimator.shallowSizeOfInstance(DateTimeValue.class) + HeapEstimator.ZONED_DATE_TIME_SIZE;
    public static final DateTimeValue MIN_VALUE = new DateTimeValue(ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.MIN));
    public static final DateTimeValue MAX_VALUE = new DateTimeValue(ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.MAX));
    private final ZonedDateTime value;
    private final long epochSeconds;
    private static final Pattern PATTERN = Pattern.compile(DateValue.DATE_PATTERN + "(?<time>T(?:(?:(?<longHour>[0-9]{1,2})(?::(?<longMinute>[0-9]{1,2})(?::(?<longSecond>[0-9]{1,2})(?:[\\.,](?<longFraction>[0-9]{1,9}))?)?)?)|(?:(?<shortHour>[0-9]{2})(?:(?<shortMinute>[0-9]{2})(?:(?<shortSecond>[0-9]{2})(?:[\\.,](?<shortFraction>[0-9]{1,9}))?)?)?))(?:(?<zone>Z|[+-](?<zoneHour>[0-9]{2})(?::?(?<zoneMinute>[0-9]{2}))?))?(?:\\[(?<zoneName>[a-zA-Z0-9~._ /+-]+)])?)?", 2);
    private static final DateTimeFormatter ZONE_NAME_PARSER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendZoneRegionId().toFormatter();

    private DateTimeValue(ZonedDateTime value) {
        ZoneId zone = value.getZone().normalized();
        if (zone instanceof ZoneOffset) {
            this.value = value;
        } else {
            ZoneId mappedZone = ZoneId.of(TimeZones.map(TimeZones.map(zone.getId())));
            this.value = value.withZoneSameInstant(mappedZone);
        }
        this.epochSeconds = this.value.toEpochSecond();
    }

    public static DateTimeValue datetime(DateValue date, LocalTimeValue time, ZoneId zone) {
        return new DateTimeValue(ZonedDateTime.of(date.temporal(), time.temporal(), zone));
    }

    public static DateTimeValue datetime(DateValue date, TimeValue time) {
        OffsetTime t = time.temporal();
        return new DateTimeValue(ZonedDateTime.of(date.temporal(), t.toLocalTime(), t.getOffset()));
    }

    public static DateTimeValue datetime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, String zone) {
        return DateTimeValue.datetime(year, month, day, hour, minute, second, nanoOfSecond, DateTimeValue.parseZoneName(zone));
    }

    public static DateTimeValue datetime(int year, int month, int day, int hour, int minute, int second, int nanoOfSecond, ZoneId zone) {
        return new DateTimeValue(DateTimeValue.assertValidArgument(() -> ZonedDateTime.of(year, month, day, hour, minute, second, nanoOfSecond, zone)));
    }

    public static DateTimeValue datetime(long epochSecond, long nano, ZoneOffset zoneOffset) {
        return new DateTimeValue(DateTimeValue.datetimeRaw(epochSecond, nano, zoneOffset));
    }

    public static ZonedDateTime datetimeRaw(long epochSecond, long nano, ZoneOffset zoneOffset) {
        return DateTimeValue.datetimeRaw(epochSecond, nano, (ZoneId)zoneOffset);
    }

    public static DateTimeValue datetime(ZonedDateTime datetime) {
        return new DateTimeValue(Objects.requireNonNull(datetime, "ZonedDateTime"));
    }

    public static DateTimeValue datetime(OffsetDateTime datetime) {
        return new DateTimeValue(Objects.requireNonNull(datetime, "OffsetDateTime").toZonedDateTime());
    }

    public static DateTimeValue datetime(long epochSecondUTC, long nano, ZoneId zone) {
        return new DateTimeValue(DateTimeValue.datetimeRaw(epochSecondUTC, nano, zone));
    }

    public static ZonedDateTime datetimeRaw(long epochSecondUTC, long nano, ZoneId zone) {
        return DateTimeValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(epochSecondUTC, nano), zone));
    }

    public static DateTimeValue ofEpoch(IntegralValue epochSecondUTC, IntegralValue nano) {
        long ns = IntegralValue.safeCastIntegral("nanosecond", nano, 0L);
        long upperNano = 1000000000L;
        if (ns < 0L || ns >= 1000000000L) {
            throw InvalidArgumentException.invalidNanosecond((long)999999999L, (long)ns);
        }
        return new DateTimeValue(DateTimeValue.datetimeRaw(epochSecondUTC.longValue(), ns, ZoneOffset.UTC));
    }

    public static DateTimeValue ofEpochMillis(IntegralValue millisUTC) {
        return new DateTimeValue(DateTimeValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(millisUTC.longValue()), ZoneOffset.UTC)));
    }

    public static DateTimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone, CSVHeaderInformation fieldsFromHeader) {
        if (fieldsFromHeader != null) {
            if (!(fieldsFromHeader instanceof TemporalValue.TimeCSVHeaderInformation)) {
                throw new IllegalStateException("Wrong header information type: " + String.valueOf(fieldsFromHeader));
            }
            defaultZone = ((TemporalValue.TimeCSVHeaderInformation)fieldsFromHeader).zoneSupplier(defaultZone);
        }
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue parse(CharSequence text, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue parse(TextValue text, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.parse(DateTimeValue.class, PATTERN, DateTimeValue::parse, text, defaultZone);
    }

    public static DateTimeValue now(Clock clock) {
        return new DateTimeValue(ZonedDateTime.now(clock));
    }

    public static DateTimeValue now(Clock clock, String timezone) {
        return DateTimeValue.now(clock.withZone(DateTimeValue.parseZoneName(timezone)));
    }

    public static DateTimeValue now(Clock clock, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.now(clock.withZone(defaultZone.get()));
    }

    public static DateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return (DateTimeValue)StructureBuilder.build(DateTimeValue.builder(defaultZone), map);
    }

    public static DateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateTimeValue.builder(defaultZone).selectDateTime(from);
    }

    public static DateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        Pair<LocalDate, LocalTime> pair = DateTimeValue.getTruncatedDateAndTime(unit, input, "date time");
        LocalDate truncatedDate = (LocalDate)pair.first();
        LocalTime truncatedTime = (LocalTime)pair.other();
        ZoneId zoneId = input.supportsTimeZone() ? input.getZoneId(defaultZone) : defaultZone.get();
        ZonedDateTime truncatedZDT = ZonedDateTime.of(truncatedDate, truncatedTime, zoneId);
        if (fields.size() == 0) {
            return DateTimeValue.datetime(truncatedZDT);
        }
        AnyValue timezone = fields.get("timezone");
        if (timezone != Values.NO_VALUE) {
            truncatedZDT = truncatedZDT.withZoneSameLocal(DateTimeValue.timezoneOf(timezone));
        }
        return DateTimeValue.updateFieldMapWithConflictingSubseconds(fields, unit, truncatedZDT, (mapValue, zonedDateTime) -> {
            if (mapValue.size() == 0) {
                return DateTimeValue.datetime(zonedDateTime);
            }
            return DateTimeValue.build(mapValue.updatedWith("datetime", DateTimeValue.datetime(zonedDateTime)), defaultZone);
        });
    }

    static DateTimeBuilder<DateTimeValue> builder(final Supplier<ZoneId> defaultZone) {
        return new DateTimeBuilder<DateTimeValue>(defaultZone){
            private final ZonedDateTime defaultZonedDateTime;
            {
                super(defaultZone2);
                this.defaultZonedDateTime = ZonedDateTime.of(TemporalValue.TemporalFields.year.defaultValue, TemporalValue.TemporalFields.month.defaultValue, TemporalValue.TemporalFields.day.defaultValue, TemporalValue.TemporalFields.hour.defaultValue, TemporalValue.TemporalFields.minute.defaultValue, TemporalValue.TemporalFields.second.defaultValue, TemporalValue.TemporalFields.nanosecond.defaultValue, this.timezone());
            }

            @Override
            protected boolean supportsTimeZone() {
                return true;
            }

            @Override
            protected boolean supportsEpoch() {
                return true;
            }

            @Override
            public DateTimeValue buildInternal() {
                boolean selectingTimeZone;
                ZonedDateTime result;
                boolean selectingEpoch;
                boolean selectingDate = this.fields.containsKey((Object)TemporalValue.TemporalFields.date);
                boolean selectingTime = this.fields.containsKey((Object)TemporalValue.TemporalFields.time);
                boolean selectingDateTime = this.fields.containsKey((Object)TemporalValue.TemporalFields.datetime);
                boolean bl = selectingEpoch = this.fields.containsKey((Object)TemporalValue.TemporalFields.epochSeconds) || this.fields.containsKey((Object)TemporalValue.TemporalFields.epochMillis);
                if (selectingDateTime) {
                    AnyValue dtField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.datetime);
                    if (!(dtField instanceof TemporalValue)) {
                        String string;
                        if (dtField instanceof Value) {
                            Value v = (Value)dtField;
                            string = v.prettyPrint();
                        } else {
                            string = String.valueOf(dtField);
                        }
                        String prettyVal = string;
                        throw InvalidArgumentException.cannotConstructTemporal((String)"date time", (String)String.valueOf(dtField), (String)prettyVal);
                    }
                    TemporalValue dt = (TemporalValue)dtField;
                    LocalTime timePart = dt.getTimePart(defaultZone).toLocalTime();
                    ZoneId zoneId = dt.getZoneId(defaultZone);
                    result = ZonedDateTime.of(dt.getDatePart(), timePart, zoneId);
                    selectingTimeZone = dt.supportsTimeZone();
                } else if (selectingEpoch) {
                    if (this.fields.containsKey((Object)TemporalValue.TemporalFields.epochSeconds)) {
                        epochField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.epochSeconds);
                        if (!(epochField instanceof IntegralValue)) {
                            String string;
                            if (epochField instanceof Value) {
                                Value v = (Value)epochField;
                                string = v.prettyPrint();
                            } else {
                                string = String.valueOf(epochField);
                            }
                            String prettyVal = string;
                            throw InvalidArgumentException.cannotConstructTemporal((String)"date time", (String)String.valueOf(epochField), (String)prettyVal);
                        }
                        IntegralValue epochSeconds = (IntegralValue)epochField;
                        result = TemporalValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochSeconds.longValue() * 1000L), this.timezone()));
                    } else {
                        epochField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.epochMillis);
                        if (!(epochField instanceof IntegralValue)) {
                            String string;
                            if (epochField instanceof Value) {
                                Value v = (Value)epochField;
                                string = v.prettyPrint();
                            } else {
                                string = String.valueOf(epochField);
                            }
                            String prettyVal = string;
                            throw InvalidArgumentException.cannotConstructTemporal((String)"date time", (String)String.valueOf(epochField), (String)prettyVal);
                        }
                        IntegralValue epochMillis = (IntegralValue)epochField;
                        result = TemporalValue.assertValidArgument(() -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis.longValue()), this.timezone()));
                    }
                    selectingTimeZone = false;
                } else if (selectingTime || selectingDate) {
                    LocalDate date;
                    ZoneId zoneId;
                    LocalTime time;
                    if (selectingTime) {
                        AnyValue timeField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.time);
                        if (!(timeField instanceof TemporalValue)) {
                            String string;
                            if (timeField instanceof Value) {
                                Value v = (Value)timeField;
                                string = v.prettyPrint();
                            } else {
                                string = String.valueOf(timeField);
                            }
                            String prettyVal = string;
                            throw InvalidArgumentException.cannotConstructTemporal((String)"time", (String)String.valueOf(timeField), (String)prettyVal);
                        }
                        TemporalValue t = (TemporalValue)timeField;
                        time = t.getTimePart(defaultZone).toLocalTime();
                        zoneId = t.getZoneId(defaultZone);
                        selectingTimeZone = t.supportsTimeZone();
                    } else {
                        time = LocalTimeValue.DEFAULT_LOCAL_TIME;
                        zoneId = this.timezone();
                        selectingTimeZone = false;
                    }
                    if (selectingDate) {
                        AnyValue dateField = (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.date);
                        if (!(dateField instanceof TemporalValue)) {
                            String string;
                            if (dateField instanceof Value) {
                                Value v = (Value)dateField;
                                string = v.prettyPrint();
                            } else {
                                string = String.valueOf(dateField);
                            }
                            String prettyVal = string;
                            throw InvalidArgumentException.cannotConstructTemporal((String)"date", (String)String.valueOf(dateField), (String)prettyVal);
                        }
                        TemporalValue t = (TemporalValue)dateField;
                        date = t.getDatePart();
                    } else {
                        date = DateValue.DEFAULT_CALENDER_DATE;
                    }
                    result = ZonedDateTime.of(date, time, zoneId);
                } else {
                    result = this.defaultZonedDateTime;
                    selectingTimeZone = false;
                }
                if (this.fields.containsKey((Object)TemporalValue.TemporalFields.week) && !selectingDate && !selectingDateTime && !selectingEpoch) {
                    result = result.with(IsoFields.WEEK_BASED_YEAR, IntegralValue.safeCastIntegral(TemporalValue.TemporalFields.year.name(), (AnyValue)this.fields.get((Object)TemporalValue.TemporalFields.year), TemporalValue.TemporalFields.year.defaultValue)).with(IsoFields.WEEK_OF_WEEK_BASED_YEAR, 1L).with(ChronoField.DAY_OF_WEEK, 1L);
                }
                result = this.assignAllFields(result);
                if (this.timezone != null) {
                    if ((selectingTime || selectingDateTime) && selectingTimeZone || selectingEpoch) {
                        try {
                            result = result.withZoneSameInstant(this.timezone());
                        }
                        catch (DateTimeParseException e) {
                            throw TemporalParseException.failedToProcessDateTime((String)this.timezone.prettyPrint(), (DateTimeParseException)e);
                        }
                    } else {
                        result = result.withZoneSameLocal(this.timezone());
                    }
                }
                return DateTimeValue.datetime(result);
            }

            @Override
            protected DateTimeValue selectDateTime(AnyValue datetime) {
                if (datetime instanceof DateTimeValue) {
                    DateTimeValue value = (DateTimeValue)datetime;
                    ZoneId zone = this.optionalTimezone();
                    return zone == null ? value : new DateTimeValue(ZonedDateTime.of(value.temporal().toLocalDateTime(), zone));
                }
                if (datetime instanceof LocalDateTimeValue) {
                    LocalDateTimeValue value = (LocalDateTimeValue)datetime;
                    return new DateTimeValue(ZonedDateTime.of(value.temporal(), this.timezone()));
                }
                throw new UnsupportedTemporalUnitException("Cannot select datetime from: " + String.valueOf(datetime));
            }
        };
    }

    @Override
    ZonedDateTime temporal() {
        return this.value;
    }

    @Override
    LocalDate getDatePart() {
        return this.value.toLocalDate();
    }

    @Override
    LocalTime getLocalTimePart() {
        return this.value.toLocalTime();
    }

    @Override
    OffsetTime getTimePart(Supplier<ZoneId> defaultZone) {
        ZoneOffset offset = this.value.getOffset();
        LocalTime localTime = this.value.toLocalTime();
        return OffsetTime.of(localTime, offset);
    }

    @Override
    ZoneId getZoneId(Supplier<ZoneId> defaultZone) {
        return this.value.getZone();
    }

    @Override
    ZoneOffset getZoneOffset() {
        return this.value.getOffset();
    }

    @Override
    public boolean supportsTimeZone() {
        return true;
    }

    @Override
    boolean hasTime() {
        return true;
    }

    @Override
    public boolean equals(Value other) {
        if (other instanceof DateTimeValue) {
            DateTimeValue dateTimeValue = (DateTimeValue)other;
            ZonedDateTime that = dateTimeValue.value;
            boolean res = this.value.toLocalDateTime().equals(that.toLocalDateTime());
            if (res) {
                ZoneId thisZone = this.value.getZone();
                ZoneId thatZone = that.getZone();
                boolean thisIsOffset = thisZone instanceof ZoneOffset;
                boolean thatIsOffset = thatZone instanceof ZoneOffset;
                res = thisIsOffset && thatIsOffset ? thisZone.equals(thatZone) : (!thisIsOffset && !thatIsOffset ? TimeZones.map(thisZone.getId()) == TimeZones.map(thatZone.getId()) : false);
            }
            return res;
        }
        return false;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        writer.writeDateTime(this.value);
    }

    @Override
    protected int unsafeCompareTo(Value other) {
        DateTimeValue that = (DateTimeValue)other;
        int cmp = Long.compare(this.epochSeconds, that.epochSeconds);
        if (cmp == 0 && (cmp = this.value.toLocalTime().getNano() - that.value.toLocalTime().getNano()) == 0) {
            ZoneOffset thisOffset = this.value.getOffset();
            ZoneOffset thatOffset = that.value.getOffset();
            cmp = Integer.compare(thisOffset.getTotalSeconds(), thatOffset.getTotalSeconds());
            if (cmp == 0) {
                boolean thisIsOffset;
                ZoneId thisZone = this.value.getZone();
                ZoneId thatZone = that.value.getZone();
                boolean thatIsOffset = thatZone instanceof ZoneOffset;
                cmp = Boolean.compare(thatIsOffset, thisIsOffset = thisZone instanceof ZoneOffset);
                if (cmp == 0 && !thisIsOffset) {
                    cmp = DateTimeValue.compareNamedZonesWithMapping(thisZone, thatZone);
                }
                if (cmp == 0) {
                    cmp = this.value.getChronology().compareTo(that.value.getChronology());
                }
            }
        }
        return cmp;
    }

    private static int compareNamedZonesWithMapping(ZoneId thisZone, ZoneId thatZone) {
        String thisZoneNormalized = TimeZones.map(TimeZones.map(thisZone.getId()));
        String thatZoneNormalized = TimeZones.map(TimeZones.map(thatZone.getId()));
        return thisZoneNormalized.compareTo(thatZoneNormalized);
    }

    @Override
    public String prettyPrint() {
        return DateTimeValue.assertPrintable(String.valueOf(this.value), () -> this.value.format(DateTimeFormatter.ISO_DATE_TIME));
    }

    @Override
    public ValueRepresentation valueRepresentation() {
        return ValueRepresentation.ZONED_DATE_TIME;
    }

    @Override
    protected int computeHashToMemoize() {
        return this.value.toInstant().hashCode();
    }

    @Override
    public String getTypeName() {
        return "DateTime";
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapDateTime(this);
    }

    public DateTimeValue add(DurationValue duration) {
        return this.replacement(DateTimeValue.assertValidArithmetic(() -> this.value.plus(duration)));
    }

    public DateTimeValue sub(DurationValue duration) {
        return this.replacement(DateTimeValue.assertValidArithmetic(() -> this.value.minus(duration)));
    }

    @Override
    DateTimeValue replacement(ZonedDateTime datetime) {
        return this.value == datetime ? this : new DateTimeValue(datetime);
    }

    public long estimatedHeapUsage() {
        return INSTANCE_SIZE;
    }

    private static DateTimeValue parse(Matcher matcher, Supplier<ZoneId> defaultZone) {
        ZoneId zone;
        LocalDateTime local = LocalDateTime.of(DateValue.parseDate(matcher), LocalDateTimeValue.optTime(matcher));
        String zoneName = matcher.group("zoneName");
        ZoneOffset offset = TimeValue.parseOffset(matcher);
        if (zoneName != null) {
            zone = DateTimeValue.parseZoneName(zoneName);
            if (offset != null) {
                try {
                    if (!zone.getRules().isValidOffset(local, offset)) {
                        String actualOffset = String.valueOf(offset);
                        List<String> validOffsets = zone.getRules().getValidOffsets(local).stream().map(String::valueOf).toList();
                        String context = String.format("%s[%s]", local, zoneName);
                        throw InvalidArgumentException.timezoneAndOffsetMismatch((String)context, (String)actualOffset, validOffsets, (String)matcher.group());
                    }
                }
                catch (ZoneRulesException e) {
                    throw TemporalParseException.cannotProcessCause((String)matcher.group(), (Throwable)e);
                }
            }
        } else {
            zone = offset != null ? offset : defaultZone.get();
        }
        return new DateTimeValue(ZonedDateTime.ofLocal(local, zone, offset));
    }

    static ZoneId parseZoneName(String zoneName) {
        ZoneId parsedName;
        try {
            parsedName = ZONE_NAME_PARSER.parse(zoneName.replace(' ', '_')).query(TemporalQueries.zoneId());
        }
        catch (DateTimeParseException e) {
            throw TemporalParseException.invalidTimeZone((String)zoneName, (DateTimeParseException)e);
        }
        return parsedName;
    }

    public static ZoneId parseZoneOffsetOrZoneName(String zoneName) {
        Matcher matcher = TimeValue.OFFSET.matcher(zoneName);
        if (matcher.matches()) {
            return TimeValue.parseOffset(matcher);
        }
        try {
            return ZONE_NAME_PARSER.parse(zoneName.replace(' ', '_')).query(TemporalQueries.zoneId());
        }
        catch (DateTimeParseException e) {
            throw TemporalParseException.invalidTimeZone((String)zoneName, (DateTimeParseException)e);
        }
    }

    static abstract class DateTimeBuilder<Result>
    extends TemporalValue.Builder<Result> {
        DateTimeBuilder(Supplier<ZoneId> defaultZone) {
            super(defaultZone);
        }

        @Override
        protected final boolean supportsDate() {
            return true;
        }

        @Override
        protected final boolean supportsTime() {
            return true;
        }

        protected abstract Result selectDateTime(AnyValue var1);
    }
}

