/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AbstractStatement;
import org.neo4j.cypherdsl.core.Match;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.INTERNAL, since="1.0")
class SinglePartQuery
extends AbstractStatement
implements Statement.SingleQuery {
    private final List<Visitable> precedingClauses;

    static SinglePartQuery create(List<Visitable> precedingClauses, Return aReturn) {
        if (precedingClauses.isEmpty() || precedingClauses.get(precedingClauses.size() - 1) instanceof Match) {
            Assertions.notNull(aReturn, "A return clause is required.");
        }
        if (aReturn == null) {
            if (precedingClauses.get(precedingClauses.size() - 1) instanceof ResultStatement) {
                return new SinglePartQueryAsResultStatementWrapper(precedingClauses);
            }
            return new SinglePartQuery(precedingClauses);
        }
        return new SinglePartQueryWithResult(precedingClauses, aReturn);
    }

    private SinglePartQuery(List<Visitable> precedingClauses) {
        this.precedingClauses = new ArrayList<Visitable>(precedingClauses);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.precedingClauses.forEach(c -> c.accept(visitor));
        visitor.leave(this);
    }

    static final class SinglePartQueryAsResultStatementWrapper
    extends SinglePartQuery
    implements ResultStatement {
        private SinglePartQueryAsResultStatementWrapper(List<Visitable> precedingClauses) {
            super(precedingClauses);
        }
    }

    static final class SinglePartQueryWithResult
    extends SinglePartQuery
    implements ResultStatement {
        private final Return aReturn;

        private SinglePartQueryWithResult(List<Visitable> precedingClauses, Return aReturn) {
            super(precedingClauses);
            this.aReturn = aReturn;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.enter(this);
            this.precedingClauses.forEach(c -> c.accept(visitor));
            this.aReturn.accept(visitor);
            visitor.leave(this);
        }

        @Override
        public String toString() {
            return RendererBridge.render(this);
        }
    }
}

