/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.connection;

import io.netty.resolver.InetNameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.neo4j.bolt.connection.DomainNameResolver;

public class NettyDomainNameResolver
extends InetNameResolver {
    private final DomainNameResolver domainNameResolver;

    public NettyDomainNameResolver(EventExecutor executor, DomainNameResolver domainNameResolver) {
        super(executor);
        this.domainNameResolver = domainNameResolver;
    }

    protected void doResolve(String inetHost, Promise<InetAddress> promise) {
        try {
            promise.setSuccess((Object)this.domainNameResolver.resolve(inetHost)[0]);
        }
        catch (UnknownHostException e) {
            promise.setFailure((Throwable)e);
        }
    }

    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) {
        try {
            promise.setSuccess(Arrays.asList(this.domainNameResolver.resolve(inetHost)));
        }
        catch (UnknownHostException e) {
            promise.setFailure((Throwable)e);
        }
    }
}

