/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.commands;

import java.util.List;
import org.neo4j.shell.DatabaseManager;
import org.neo4j.shell.commands.Command;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.exception.CommandException;
import org.neo4j.shell.exception.ExitException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Use
implements Command {
    private final DatabaseManager databaseManager;

    public Use(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    @Override
    public void execute(List<String> args) throws ExitException, CommandException {
        this.requireArgumentCount(args, 0, 1);
        String databaseName = args.size() == 0 ? "" : args.get(0);
        this.databaseManager.setActiveDatabase(CommandHelper.stripEnclosingBackTicks(databaseName));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Factory
    implements Command.Factory {
        @Override
        public Command.Metadata metadata() {
            String help = "Set the active database that transactions are executed on";
            return new Command.Metadata(":use", "Set the active database", "database", help, List.of());
        }

        @Override
        public Command executor(Command.Factory.Arguments args) {
            return new Use(args.cypherShell());
        }
    }
}

