/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public final class HeapTrackingLongHashSet
extends LongHashSet
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingLongHashSet.class);
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final MemoryTracker memoryTracker;
    private int trackedCapacity;

    public static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker) {
        return HeapTrackingLongHashSet.createLongHashSet(memoryTracker, 16);
    }

    static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker, HeapTrackingLongHashSet set) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongHashSet.arrayHeapSize(set.trackedCapacity));
        return new HeapTrackingLongHashSet(memoryTracker, set);
    }

    static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker, LongSet set) {
        memoryTracker.allocateHeap(SHALLOW_SIZE);
        return new HeapTrackingLongHashSet(memoryTracker, set);
    }

    static HeapTrackingLongHashSet createLongHashSet(MemoryTracker memoryTracker, int initialCapacity) {
        int capacity = Numbers.ceilingPowerOfTwo((int)(initialCapacity << 1));
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingLongHashSet.arrayHeapSize(capacity));
        return new HeapTrackingLongHashSet(memoryTracker, initialCapacity, capacity);
    }

    private HeapTrackingLongHashSet(MemoryTracker memoryTracker, int initialCapacity, int actualCapacity) {
        super(initialCapacity);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = actualCapacity;
    }

    private HeapTrackingLongHashSet(MemoryTracker memoryTracker, HeapTrackingLongHashSet set) {
        super((LongHashSet)set);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = set.trackedCapacity;
    }

    private HeapTrackingLongHashSet(MemoryTracker memoryTracker, LongSet set) {
        super((LongIterable)set);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingLongHashSet.arrayHeapSize(sizeToAllocate));
            this.memoryTracker.releaseHeap(HeapTrackingLongHashSet.arrayHeapSize(this.trackedCapacity));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingLongHashSet.arrayHeapSize(this.trackedCapacity) + SHALLOW_SIZE);
    }

    @VisibleForTesting
    public static long arrayHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 8L));
    }
}

