/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Collections;
import java.util.Iterator;
import org.neo4j.internal.helpers.collection.Iterables;

public interface BoundedIterable<RECORD>
extends Iterable<RECORD>,
AutoCloseable {
    public static final long UNKNOWN_MAX_COUNT = -1L;

    public long maxCount();

    public static <T> BoundedIterable<T> empty() {
        return new BoundedIterable<T>(){

            @Override
            public long maxCount() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public Iterator<T> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    public static <T> BoundedIterable<T> concat(final Iterable<BoundedIterable<T>> iterables) {
        long maxCount = 0L;
        for (BoundedIterable<T> iterable : iterables) {
            long count = iterable.maxCount();
            if (count == -1L) {
                maxCount = -1L;
                break;
            }
            maxCount += iterable.maxCount();
        }
        final long finalMaxCount = maxCount;
        return new BoundedIterable<T>(){

            @Override
            public long maxCount() {
                return finalMaxCount;
            }

            @Override
            public void close() throws Exception {
                Iterables.safeForAll(iterables, AutoCloseable::close);
            }

            @Override
            public Iterator<T> iterator() {
                return Iterables.concat(iterables).iterator();
            }
        };
    }
}

