/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.async.DelegatingResponseHandler;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.util.Futures;

final class TerminationAwareResponseHandler
extends DelegatingResponseHandler {
    private final Logger log;
    private final TerminationAwareStateLockingExecutor executor;
    private final Consumer<Throwable> throwableConsumer;

    TerminationAwareResponseHandler(Logging logging, DriverResponseHandler delegate, TerminationAwareStateLockingExecutor executor, Consumer<Throwable> throwableConsumer) {
        super(delegate);
        this.log = logging.getLog(this.getClass());
        this.executor = Objects.requireNonNull(executor);
        this.throwableConsumer = Objects.requireNonNull(throwableConsumer);
    }

    @Override
    public void onError(Throwable throwable) {
        this.throwableConsumer.accept(Futures.completionExceptionCause(throwable));
        super.onError(throwable);
    }

    @Override
    public void onComplete() {
        Throwable throwable = (Throwable)this.executor.execute(Function.identity());
        if (throwable != null) {
            this.log.trace("Reporting an existing %s error to delegate", throwable.getClass().getCanonicalName());
            this.delegate.onError(throwable);
        }
        this.log.trace("Completing delegate", new Object[0]);
        this.delegate.onComplete();
    }
}

