/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.driver.Record;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.cursor.ResultCursorImpl;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.summary.ResultSummary;

public class DisposableResultCursorImpl
implements ResultCursor,
FailableCursor {
    private final ResultCursorImpl delegate;
    private boolean isDisposed;

    public DisposableResultCursorImpl(ResultCursorImpl delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public List<String> keys() {
        return this.delegate.keys();
    }

    @Override
    public CompletionStage<ResultSummary> consumeAsync() {
        this.isDisposed = true;
        return this.delegate.consumeAsync();
    }

    @Override
    public CompletionStage<Record> nextAsync() {
        return this.assertNotDisposed().thenCompose(ignored -> this.delegate.nextAsync());
    }

    @Override
    public CompletionStage<Record> peekAsync() {
        return this.assertNotDisposed().thenCompose(ignored -> this.delegate.peekAsync());
    }

    @Override
    public CompletionStage<Record> singleAsync() {
        return this.assertNotDisposed().thenCompose(ignored -> this.delegate.singleAsync());
    }

    @Override
    public CompletionStage<ResultSummary> forEachAsync(Consumer<Record> action) {
        return this.assertNotDisposed().thenCompose(ignored -> this.delegate.forEachAsync(action));
    }

    @Override
    public CompletionStage<List<Record>> listAsync() {
        return this.assertNotDisposed().thenCompose(ignored -> this.delegate.listAsync());
    }

    @Override
    public <T> CompletionStage<List<T>> listAsync(Function<Record, T> mapFunction) {
        return this.assertNotDisposed().thenCompose(ignored -> this.delegate.listAsync(mapFunction));
    }

    @Override
    public CompletionStage<Boolean> isOpenAsync() {
        return CompletableFuture.completedFuture(!this.isDisposed());
    }

    private <T> CompletableFuture<T> assertNotDisposed() {
        if (this.isDisposed) {
            return CompletableFuture.failedFuture(ErrorUtil.newResultConsumedError());
        }
        return Futures.completedWithNull();
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public CompletionStage<Throwable> discardAllFailureAsync() {
        this.isDisposed = true;
        return this.delegate.discardAllFailureAsync();
    }

    @Override
    public CompletionStage<Throwable> pullAllFailureAsync() {
        return this.delegate.pullAllFailureAsync();
    }

    @Override
    public CompletionStage<Void> consumed() {
        return this.delegate().consumed();
    }

    public ResultCursorImpl delegate() {
        return this.delegate;
    }
}

