/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Asterisk;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.STABLE, since="1.0")
public final class MapProjection
implements Expression {
    private final SymbolicName name;
    private final MapExpression map;

    @API(status=API.Status.INTERNAL, since="2023.9.0")
    public static MapProjection create(SymbolicName name, Object ... content) {
        return new MapProjection(name, MapExpression.withEntries(MapProjection.createNewContent(false, content)));
    }

    @API(status=API.Status.INTERNAL, since="2024.1.1")
    public static MapProjection sorted(SymbolicName name, Object ... content) {
        return new MapProjection(name, MapExpression.withEntries(MapProjection.createNewContent(true, content)));
    }

    MapProjection(SymbolicName name, MapExpression map) {
        this.name = name;
        this.map = map;
    }

    @NotNull
    @Contract(pure=true)
    public MapProjection and(Object ... content) {
        return new MapProjection(this.name, this.map.addEntries(MapProjection.createNewContent(false, content)));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.name.accept(visitor);
        this.map.accept(visitor);
        visitor.leave(this);
    }

    private static Object contentAt(Object[] content, int i) {
        Object currentObject = content[i];
        if (currentObject instanceof Expression) {
            Expression expression = (Expression)currentObject;
            return Expressions.nameOrExpression(expression);
        }
        if (currentObject instanceof Named) {
            Named named = (Named)currentObject;
            return named.getSymbolicName().map(Object.class::cast).orElse(currentObject);
        }
        return currentObject;
    }

    private static List<Expression> createNewContent(boolean sort, Object ... content) {
        ArrayList<Expression> newContent = new ArrayList<Expression>(content.length);
        HashSet<String> knownKeys = new HashSet<String>();
        String lastKey = null;
        Expression lastExpression = null;
        int i = 0;
        while (i < content.length) {
            Object next = i + 1 >= content.length ? null : MapProjection.contentAt(content, i + 1);
            Object current = MapProjection.contentAt(content, i);
            if (current instanceof String) {
                String stringValue = (String)current;
                if (next instanceof Expression) {
                    Expression expression = (Expression)next;
                    lastKey = stringValue;
                    lastExpression = expression;
                    i += 2;
                } else {
                    lastExpression = PropertyLookup.forName((String)current);
                    ++i;
                }
            } else if (current instanceof Expression) {
                Expression expression;
                lastExpression = expression = (Expression)current;
                ++i;
            }
            if (lastExpression instanceof Asterisk) {
                lastExpression = PropertyLookup.wildcard();
            }
            if (lastKey != null) {
                Assertions.isTrue(!knownKeys.contains(lastKey), "Duplicate key '" + lastKey + "'");
                newContent.add(KeyValueMapEntry.create(lastKey, lastExpression));
                knownKeys.add(lastKey);
            } else if (lastExpression instanceof SymbolicName || lastExpression instanceof PropertyLookup) {
                newContent.add(lastExpression);
            } else if (lastExpression instanceof Property) {
                Property property = (Property)lastExpression;
                List<PropertyLookup> names = property.getNames();
                if (names.size() > 1) {
                    throw new IllegalArgumentException("Cannot project nested properties!");
                }
                newContent.addAll(names);
            } else if (lastExpression instanceof AliasedExpression) {
                AliasedExpression aliasedExpression = (AliasedExpression)lastExpression;
                newContent.add(KeyValueMapEntry.create(aliasedExpression.getAlias(), aliasedExpression));
            } else if (lastExpression instanceof KeyValueMapEntry) {
                newContent.add(lastExpression);
            } else {
                if (lastExpression == null) {
                    throw new IllegalArgumentException("Could not determine an expression from the given content!");
                }
                throw new IllegalArgumentException(lastExpression + " of type " + lastExpression.getClass() + " cannot be used with an implicit name as map entry.");
            }
            lastKey = null;
            lastExpression = null;
        }
        if (sort) {
            newContent.sort((o1, o2) -> {
                if (o1 instanceof KeyValueMapEntry) {
                    KeyValueMapEntry kvm1 = (KeyValueMapEntry)o1;
                    if (o2 instanceof KeyValueMapEntry) {
                        KeyValueMapEntry kvm2 = (KeyValueMapEntry)o2;
                        return kvm1.getKey().compareTo(kvm2.getKey());
                    }
                }
                if (o1 instanceof PropertyLookup) {
                    PropertyLookup pl1 = (PropertyLookup)o1;
                    if (o2 instanceof PropertyLookup) {
                        PropertyLookup pl2 = (PropertyLookup)o2;
                        if (pl1 == PropertyLookup.wildcard()) {
                            return -1;
                        }
                        if (pl2 == PropertyLookup.wildcard()) {
                            return 1;
                        }
                        return pl1.getPropertyKeyName().getValue().compareTo(pl2.getPropertyKeyName().getValue());
                    }
                }
                if (o1 instanceof PropertyLookup) {
                    return 1;
                }
                return -1;
            });
        }
        return newContent;
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

