/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers;

import org.neo4j.util.Preconditions;

public final class Numbers {
    private static final long MAX_POWER_OF_TWO_LONG = 0x4000000000000000L;
    private static final long MAX_POWER_OF_TWO_INTEGER = 0x40000000L;

    private Numbers() {
    }

    public static boolean isPowerOfTwo(long value) {
        Preconditions.requirePositive(value);
        return (value & value - 1L) == 0L;
    }

    public static long ceilingPowerOfTwo(long value) {
        Preconditions.requirePositive(value);
        if (value > 0x4000000000000000L) {
            throw new IllegalArgumentException("Provided value " + value + " is larger than the largest power of two long value.");
        }
        return 1L << -Long.numberOfLeadingZeros(value - 1L);
    }

    public static int ceilingPowerOfTwo(int value) {
        Preconditions.requirePositive(value);
        if ((long)value > 0x40000000L) {
            throw new IllegalArgumentException("Provided value " + value + " is larger than the largest power of two long value.");
        }
        return 1 << -Integer.numberOfLeadingZeros(value - 1);
    }

    public static long floorPowerOfTwo(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Provided value " + value + " is less than 1");
        }
        return 1L << Numbers.log2floor(value);
    }

    public static int log2floor(long value) {
        return 63 - Long.numberOfLeadingZeros(Preconditions.requirePositive(value));
    }

    public static short safeCastIntToUnsignedShort(int value) {
        if ((value & 0xFFFF0000) != 0) {
            throw new ArithmeticException(Numbers.getOverflowMessage((long)value, "unsigned short"));
        }
        return (short)value;
    }

    public static byte safeCastIntToUnsignedByte(int value) {
        if ((value & 0xFFFFFF00) != 0) {
            throw new ArithmeticException(Numbers.getOverflowMessage((long)value, "unsigned byte"));
        }
        return (byte)value;
    }

    public static int safeCastLongToInt(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage(value, Integer.TYPE));
        }
        return (int)value;
    }

    public static short safeCastLongToShort(long value) {
        if ((long)((short)value) != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage(value, Short.TYPE));
        }
        return (short)value;
    }

    public static short safeCastIntToShort(int value) {
        if ((short)value != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage((long)value, Short.TYPE));
        }
        return (short)value;
    }

    public static byte safeCastLongToByte(long value) {
        if ((long)((byte)value) != value) {
            throw new ArithmeticException(Numbers.getOverflowMessage(value, Byte.TYPE));
        }
        return (byte)value;
    }

    public static int safeCheck3ByteInt(int value) {
        if ((value & 0xFF000000) != 0) {
            throw new ArithmeticException(Numbers.getOverflowMessage((long)value, "3-byte int"));
        }
        return value;
    }

    public static int unsignedShortToInt(short value) {
        return value & 0xFFFF;
    }

    public static int unsignedByteToInt(byte value) {
        return value & 0xFF;
    }

    private static String getOverflowMessage(long value, Class<?> clazz) {
        return Numbers.getOverflowMessage(value, clazz.getName());
    }

    private static String getOverflowMessage(long value, String numericType) {
        return "Value " + value + " is too big to be represented as " + numericType;
    }
}

