/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values;

import java.util.UUID;
import org.neo4j.values.ElementIdDecoderV1;

public final class ElementIdDecoder {
    private static final ElementIdDecoderV1 elementIdDecoderV1 = new ElementIdDecoderV1();

    public static long nodeId(String elementId) {
        return ElementIdDecoder.getElementIdDecoder(elementId).nodeId(elementId);
    }

    public static UUID database(String elementId) {
        return ElementIdDecoder.getElementIdDecoder(elementId).database(elementId);
    }

    public static long relationshipId(String elementId) {
        return ElementIdDecoder.getElementIdDecoder(elementId).relationshipId(elementId);
    }

    private static ElementIdDecoderV1 getElementIdDecoder(String elementId) {
        Byte version = ElementIdDecoder.getVersion(elementId);
        if (ElementIdDecoderV1.ELEMENT_ID_FORMAT_VERSION == version) {
            return elementIdDecoderV1;
        }
        throw new IllegalArgumentException(String.format("Element ID %s has an unexpected version %s", elementId, version));
    }

    private static Byte getVersion(String elementId) {
        String[] parts = elementId.split(":");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Element ID %s has an unexpected format.", elementId));
        }
        byte header = Byte.parseByte(parts[0]);
        return (byte)(header >>> 2);
    }

    public static interface VersionedElementIdDecoder {
        public long nodeId(String var1);

        public long relationshipId(String var1);

        public UUID database(String var1);
    }
}

