/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.hashing.HashFunction;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.PrimitiveArrayValues;
import org.neo4j.values.storable.PrimitiveArrayWriting;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public class StringArray
extends TextArray {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(StringArray.class);
    private final String[] value;

    StringArray(String[] value) {
        assert (value != null);
        this.value = value;
    }

    @Override
    public int intSize() {
        return this.value.length;
    }

    @Override
    public String stringValue(int offset) {
        return this.value[offset];
    }

    @Override
    public boolean equals(SequenceValue other) {
        if (other instanceof ArrayValue) {
            ArrayValue otherArray = (ArrayValue)other;
            return otherArray.equals(this.value);
        }
        return super.equals(other);
    }

    @Override
    public boolean equals(Value other) {
        return other.equals(this.value);
    }

    @Override
    public boolean equals(char[] x) {
        return PrimitiveArrayValues.equals(x, this.value);
    }

    @Override
    public boolean equals(String[] x) {
        return Arrays.equals(this.value, x);
    }

    @Override
    protected int computeHashToMemoize() {
        int result = 1;
        for (String element : this.value) {
            result = 31 * result + (element == null ? NoValue.NO_VALUE.hashCode() : Values.stringValue(element).hashCode());
        }
        return result;
    }

    @Override
    public long updateHash(HashFunction hashFunction, long hash) {
        hash = hashFunction.update(hash, (long)this.value.length);
        for (String s : this.value) {
            hash = StringWrappingStringValue.updateHash(hashFunction, hash, s);
        }
        return hash;
    }

    @Override
    public <E extends Exception> void writeTo(ValueWriter<E> writer) throws E {
        PrimitiveArrayWriting.writeTo(writer, this.value);
    }

    public String[] asObjectCopy() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    @Deprecated
    public String[] asObject() {
        return this.value;
    }

    @Override
    public String prettyPrint() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(this.intSize());
        sb.append('[').append(this.value(0).prettyPrint());
        for (int i = 1; i < this.intSize(); ++i) {
            sb.append(", ").append(this.value(i).prettyPrint());
        }
        return sb.append(']').toString();
    }

    @Override
    public Value value(int offset) {
        return Values.stringOrNoValue(this.stringValue(offset));
    }

    @Override
    public <T> T map(ValueMapper<T> mapper) {
        return mapper.mapStringArray(this);
    }

    public String toString() {
        return String.format("%s%s", this.getTypeName(), Arrays.toString(this.value));
    }

    @Override
    public String getTypeName() {
        return "StringArray";
    }

    @Override
    public long estimatedHeapUsage() {
        int length = this.value.length;
        return SHALLOW_SIZE + (length == 0 ? 0L : HeapEstimator.sizeOfObjectArray((long)HeapEstimator.sizeOf((String)this.value[0]), (int)length));
    }

    @Override
    public boolean hasCompatibleType(AnyValue value) {
        return value instanceof TextValue;
    }

    @Override
    public ArrayValue copyWithAppended(AnyValue added) {
        assert (this.hasCompatibleType(added)) : "Incompatible types";
        String[] newArray = Arrays.copyOf(this.value, this.value.length + 1);
        newArray[this.value.length] = ((TextValue)added).stringValue();
        return new StringArray(newArray);
    }

    @Override
    public ArrayValue copyWithPrepended(AnyValue prepended) {
        assert (this.hasCompatibleType(prepended)) : "Incompatible types";
        String[] newArray = new String[this.value.length + 1];
        System.arraycopy(this.value, 0, newArray, 1, this.value.length);
        newArray[0] = ((TextValue)prepended).stringValue();
        return new StringArray(newArray);
    }
}

