/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.virtual;

import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.ElementIdMapper;
import org.neo4j.values.virtual.VirtualNodeReference;

public class FullNodeReference
extends VirtualNodeReference {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(FullNodeReference.class);
    private final long id;
    private final ElementIdMapper elementIdMapper;
    private String elementId;

    FullNodeReference(long id, String elementId) {
        assert (elementId != null);
        this.id = id;
        this.elementId = elementId;
        this.elementIdMapper = null;
    }

    FullNodeReference(long id, ElementIdMapper elementIdMapper) {
        assert (elementIdMapper != null);
        this.id = id;
        this.elementId = null;
        this.elementIdMapper = elementIdMapper;
    }

    @Override
    public <E extends Exception> void writeTo(AnyValueWriter<E> writer) throws E {
        writer.writeNodeReference(this.id);
    }

    @Override
    public String getTypeName() {
        return "FullNodeReference";
    }

    public String toString() {
        return String.format("(%d)", this.id);
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String elementId() {
        if (this.elementId == null) {
            this.elementId = this.elementIdMapper.nodeElementId(this.id);
        }
        return this.elementId;
    }

    public long estimatedHeapUsage() {
        return SHALLOW_SIZE;
    }
}

