/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.terminal;

import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.neo4j.shell.commands.CommandHelper;
import org.neo4j.shell.completions.CompletionEngine;
import org.neo4j.shell.completions.Suggestion;
import org.neo4j.shell.completions.SuggestionType;
import org.neo4j.shell.terminal.StatementJlineParser;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JlineCompleter
implements Completer {
    private final CommandCompleter commandCompleter;
    private final CypherCompleter cypherCompleter;

    public JlineCompleter(CommandHelper.CommandFactoryHelper commands, CompletionEngine completionEngine) {
        this.commandCompleter = CommandCompleter.from(commands);
        this.cypherCompleter = new CypherCompleter(completionEngine);
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        try {
            if (line instanceof StatementJlineParser.BlankCompletion) {
                candidates.addAll(this.commandCompleter.complete());
                if (this.cypherCompleter.completionsEnabled()) {
                    this.cypherCompleter.completeBlank().forEach(candidates::add);
                }
            } else if (line instanceof StatementJlineParser.CommandCompletion) {
                candidates.addAll(this.commandCompleter.complete());
            } else if (this.cypherCompleter.completionsEnabled() && line instanceof StatementJlineParser.CypherCompletion) {
                StatementJlineParser.CypherCompletion cypher = (StatementJlineParser.CypherCompletion)line;
                this.cypherCompleter.complete(cypher).forEach(candidates::add);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CommandCompleter(List<Suggestion> allCommands) {
        List<Suggestion> complete() {
            return this.allCommands;
        }

        public static CommandCompleter from(CommandHelper.CommandFactoryHelper commands) {
            return new CommandCompleter(commands.metadata().map(Suggestion::command).toList());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private record CypherCompleter(CompletionEngine completionEngine) {
        public boolean completionsEnabled() {
            return this.completionEngine.completionsEnabled();
        }

        Stream<Suggestion> complete(StatementJlineParser.CypherCompletion cypher) throws IOException {
            return CypherCompleter.concat(this.completions(this.queryUntilCompletionWord(cypher), cypher.word()));
        }

        Stream<Suggestion> completeBlank() throws IOException {
            return CypherCompleter.concat(this.completions("", ""));
        }

        private String textUntilSentinel(String lastToken, char sentinel) {
            int sentinelIndex = lastToken.lastIndexOf(sentinel);
            return lastToken.substring(0, sentinelIndex + 1);
        }

        private Stream<Suggestion> completions(String query, String lastToken) throws IOException {
            Stream<Suggestion> completions = this.completionEngine.completeQuery(query).stream().map(completion -> {
                String completionType = completion.group();
                if (completionType.equals(SuggestionType.LABEL_OR_RELATIONSHIP.name)) {
                    return new Suggestion(this.textUntilSentinel(lastToken, ':') + completion.value(), completion.value(), SuggestionType.LABEL_OR_RELATIONSHIP, completion.descr(), completion.complete());
                }
                if (completionType.equals(SuggestionType.PROPERTY.name)) {
                    return new Suggestion(this.textUntilSentinel(lastToken, '.') + completion.value(), completion.value(), SuggestionType.PROPERTY, completion.descr(), completion.complete());
                }
                if (completionType.equals(SuggestionType.FUNCTION.name)) {
                    return new Suggestion(this.textUntilSentinel(lastToken, '.') + completion.value(), completion.value(), SuggestionType.FUNCTION, completion.descr(), completion.complete());
                }
                if (completionType.equals(SuggestionType.PROCEDURE.name)) {
                    return new Suggestion(this.textUntilSentinel(lastToken, '.') + completion.value(), completion.value(), SuggestionType.PROCEDURE, completion.descr(), completion.complete());
                }
                return completion;
            });
            return completions;
        }

        private String queryUntilCompletionWord(StatementJlineParser.CypherCompletion cypher) {
            int cutAt = cypher.cursor() - cypher.wordCursor() - cypher.statement().beginOffset();
            return cypher.statement().statement().substring(0, cutAt);
        }

        @SafeVarargs
        private static <T> Stream<T> concat(Stream<T> ... streams) {
            return Stream.of(streams).reduce(Stream::concat).orElseGet(Stream::empty);
        }
    }
}

