/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.netty.impl.async.inbound;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;

public class MessageDecoder
extends ByteToMessageDecoder {
    private static final ByteToMessageDecoder.Cumulator DEFAULT_CUMULATOR = MessageDecoder.determineDefaultCumulator();
    private boolean readMessageBoundary;

    public MessageDecoder() {
        this.setCumulator(DEFAULT_CUMULATOR);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            this.readMessageBoundary = ((ByteBuf)msg).readableBytes() == 0;
        }
        super.channelRead(ctx, msg);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.readMessageBoundary) {
            ByteBuf messageBuf = in.retainedDuplicate();
            in.readerIndex(in.readableBytes());
            out.add(messageBuf);
            this.readMessageBoundary = false;
        }
    }

    private static ByteToMessageDecoder.Cumulator determineDefaultCumulator() {
        String value = System.getProperty("messageDecoderCumulator", "");
        if ("merge".equals(value)) {
            return MERGE_CUMULATOR;
        }
        return COMPOSITE_CUMULATOR;
    }
}

