/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.bolt.connection.AuthTokens;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;
import org.neo4j.bolt.connection.TelemetryApi;
import org.neo4j.bolt.connection.exception.MinVersionAcquisitionException;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.Messages;
import org.neo4j.bolt.connection.message.RunMessage;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.exceptions.UnsupportedFeatureException;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.NotificationConfigMapper;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionSource;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.async.BoltConnectionWithAuthTokenManager;
import org.neo4j.driver.internal.async.BoltConnectionWithCloseTracking;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.DisposableResultCursorImpl;
import org.neo4j.driver.internal.cursor.ResultCursorImpl;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.homedb.HomeDatabaseCache;
import org.neo4j.driver.internal.homedb.HomeDatabaseCacheKey;
import org.neo4j.driver.internal.logging.PrefixedLogger;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.InternalAuthToken;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.value.BoltValueFactory;

public class NetworkSession {
    private final DriverBoltConnectionSource boltConnectionProvider;
    private final NetworkSessionConnectionContext connectionContext;
    private final AccessMode mode;
    private final RetryLogic retryLogic;
    private final Logging logging;
    protected final Logger log;
    private final long fetchSize;
    private volatile CompletionStage<UnmanagedTransaction> transactionStage = Futures.completedWithNull();
    private volatile CompletionStage<BoltConnectionWithCloseTracking> connectionStage = Futures.completedWithNull();
    private volatile CompletionStage<? extends FailableCursor> resultCursorStage = Futures.completedWithNull();
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final BookmarkManager bookmarkManager;
    private volatile Set<Bookmark> lastUsedBookmarks = Collections.emptySet();
    private volatile Set<Bookmark> lastReceivedBookmarks;
    private final org.neo4j.bolt.connection.NotificationConfig notificationConfig;
    private final boolean telemetryDisabled;
    private final AuthTokenManager authTokenManager;
    private final HomeDatabaseCache homeDatabaseCache;
    private final HomeDatabaseCacheKey homeDatabaseKey;

    public NetworkSession(DriverBoltConnectionSource boltConnectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, Set<Bookmark> bookmarks, String impersonatedUser, long fetchSize, Logging logging, BookmarkManager bookmarkManager, NotificationConfig notificationConfig, AuthToken overrideAuthToken, boolean telemetryDisabled, AuthTokenManager authTokenManager, HomeDatabaseCache homeDatabaseCache) {
        Objects.requireNonNull(bookmarks, "bookmarks may not be null");
        Objects.requireNonNull(bookmarkManager, "bookmarkManager may not be null");
        this.boltConnectionProvider = Objects.requireNonNull(boltConnectionProvider);
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logging = logging;
        this.log = new PrefixedLogger("[" + this.hashCode() + "]", logging.getLog(this.getClass()));
        CompletableFuture<DatabaseName> databaseNameFuture = databaseName.databaseName().map(ignored -> CompletableFuture.completedFuture(databaseName)).orElse(new CompletableFuture());
        this.bookmarkManager = bookmarkManager;
        this.lastReceivedBookmarks = bookmarks;
        this.connectionContext = new NetworkSessionConnectionContext(databaseNameFuture, this.determineBookmarks(false), impersonatedUser, overrideAuthToken);
        this.fetchSize = fetchSize;
        this.notificationConfig = NotificationConfigMapper.map(notificationConfig);
        this.telemetryDisabled = telemetryDisabled;
        this.authTokenManager = authTokenManager;
        this.homeDatabaseCache = Objects.requireNonNull(homeDatabaseCache);
        this.homeDatabaseKey = HomeDatabaseCacheKey.of(overrideAuthToken, impersonatedUser);
    }

    public CompletionStage<ResultCursor> runAsync(Query query, TransactionConfig config) {
        this.ensureSessionIsOpen();
        CompletionStage disposable = this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            Map<String, Value> parameters = query.parameters().asMap(Values::value);
            ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(TelemetryApi.AUTO_COMMIT_TRANSACTION);
            apiTelemetryWork.setEnabled(!this.telemetryDisabled);
            ResultCursorImpl resultCursor = new ResultCursorImpl((DriverBoltConnection)connection, query, this.fetchSize, this::handleNewBookmark, true, null, this::handleDatabaseName, null);
            CompletionStage<DisposableResultCursorImpl> cursorStage = CompletableFuture.completedStage(null).thenCompose(ignored -> {
                ArrayList<Message> messages = new ArrayList<Message>(3);
                apiTelemetryWork.getTelemetryMessageIfEnabled((DriverBoltConnection)connection).ifPresent(messages::add);
                messages.add((Message)this.newRunMessage((DriverBoltConnection)connection, query, parameters, config));
                messages.add((Message)Messages.pull((long)-1L, (long)this.fetchSize));
                return connection.writeAndFlush((DriverResponseHandler)resultCursor, messages);
            }).thenCompose(ignored -> resultCursor.resultCursor()).handle((resultCursorImpl, throwable) -> {
                Throwable error = Futures.completionExceptionCause(throwable);
                if (error != null) {
                    return connection.close().handle((ignored, closeError) -> {
                        if (closeError != null) {
                            error.addSuppressed((Throwable)closeError);
                        }
                        if (error instanceof RuntimeException) {
                            RuntimeException runtimeException = (RuntimeException)error;
                            throw runtimeException;
                        }
                        throw new CompletionException(error);
                    });
                }
                return CompletableFuture.completedStage(resultCursorImpl);
            }).thenCompose(Function.identity()).thenApply(DisposableResultCursorImpl::new);
            return cursorStage.thenApply(Function.identity());
        });
        this.resultCursorStage = disposable.exceptionally(error -> null);
        return disposable.thenApply(Function.identity());
    }

    public CompletionStage<RxResultCursor> runRx(Query query, TransactionConfig config, CompletionStage<RxResultCursor> cursorPublishStage) {
        this.ensureSessionIsOpen();
        CompletionStage<RxResultCursor> newResultCursorStage = this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            Map<String, Value> parameters = query.parameters().asMap(Values::value);
            ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(TelemetryApi.AUTO_COMMIT_TRANSACTION);
            apiTelemetryWork.setEnabled(!this.telemetryDisabled);
            AtomicBoolean runFailed = new AtomicBoolean(false);
            RunRxResponseHandler responseHandler = new RunRxResponseHandler(this.logging, (DriverBoltConnection)connection, query, this::handleNewBookmark, runFailed, this::handleDatabaseName);
            CompletionStage cursorStage = CompletableFuture.completedStage(null).thenCompose(ignored -> {
                ArrayList<Message> messages = new ArrayList<Message>(2);
                apiTelemetryWork.getTelemetryMessageIfEnabled((DriverBoltConnection)connection).ifPresent(messages::add);
                messages.add((Message)this.newRunMessage((DriverBoltConnection)connection, query, parameters, config));
                return connection.writeAndFlush((DriverResponseHandler)responseHandler, messages);
            }).thenCompose(ignored -> responseHandler.cursorFuture).handle((resultCursor, throwable) -> {
                Throwable error = Futures.completionExceptionCause(throwable);
                if (error != null) {
                    return connection.close().handle((ignored, closeError) -> {
                        if (closeError != null) {
                            error.addSuppressed((Throwable)closeError);
                        }
                        if (error instanceof RuntimeException) {
                            RuntimeException runtimeException = (RuntimeException)error;
                            throw runtimeException;
                        }
                        throw new CompletionException(error);
                    });
                }
                if (runFailed.get()) {
                    return connection.close().handle((ignored1, ignored2) -> resultCursor);
                }
                return CompletableFuture.completedStage(resultCursor);
            }).thenCompose(Function.identity());
            return cursorStage.thenApply(Function.identity());
        });
        this.resultCursorStage = newResultCursorStage.thenCompose(cursor -> cursor == null ? CompletableFuture.completedFuture(null) : cursorPublishStage).exceptionally(throwable -> null);
        return newResultCursorStage;
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(TransactionConfig config, ApiTelemetryWork apiTelemetryWork) {
        return this.beginTransactionAsync(this.mode, config, null, apiTelemetryWork, true);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork) {
        return this.beginTransactionAsync(this.mode, config, txType, apiTelemetryWork, true);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config, ApiTelemetryWork apiTelemetryWork) {
        return this.beginTransactionAsync(mode, config, null, apiTelemetryWork, true);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork, boolean flush) {
        this.ensureSessionIsOpen();
        apiTelemetryWork.setEnabled(!this.telemetryDisabled);
        CompletionStage<UnmanagedTransaction> newTransactionStage = this.ensureNoOpenTxBeforeStartingTx().thenCompose(ignore -> this.acquireConnection(mode)).thenCompose(connection -> {
            UnmanagedTransaction tx = new UnmanagedTransaction((DriverBoltConnection)connection, this.connectionContext.databaseNameFuture.getNow(DatabaseName.defaultDatabase()), NetworkSession.asBoltAccessMode(mode), this.connectionContext.impersonatedUser, this::handleNewBookmark, this.fetchSize, this.notificationConfig, apiTelemetryWork, this::handleDatabaseName, this.logging);
            return tx.beginAsync(this.determineBookmarks(true), config, txType, flush);
        });
        CompletionStage<UnmanagedTransaction> currentTransactionStage = this.transactionStage;
        this.transactionStage = newTransactionStage.exceptionally(error -> null).thenCompose(tx -> {
            if (tx == null) {
                return currentTransactionStage;
            }
            return CompletableFuture.completedFuture(tx);
        });
        return newTransactionStage;
    }

    public CompletionStage<Void> resetAsync() {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                tx.markTerminated(null);
            }
        }).thenCompose(ignore -> this.connectionStage).thenCompose(connection -> {
            if (connection != null && connection.isOpen()) {
                final CompletableFuture future = new CompletableFuture();
                return connection.writeAndFlush(new DriverResponseHandler(){

                    @Override
                    public void onError(Throwable throwable) {
                        future.completeExceptionally(throwable);
                    }

                    @Override
                    public void onComplete() {
                        future.complete(null);
                    }
                }, (Message)Messages.reset()).thenCompose(ignored -> future);
            }
            return Futures.completedWithNull();
        });
    }

    public RetryLogic retryLogic() {
        return this.retryLogic;
    }

    public Set<Bookmark> lastBookmarks() {
        return this.lastReceivedBookmarks;
    }

    public CompletionStage<Void> releaseConnectionAsync() {
        return this.connectionStage.thenCompose(connection -> {
            if (connection != null) {
                return connection.close();
            }
            return Futures.completedWithNull();
        });
    }

    public CompletionStage<DriverBoltConnection> connectionAsync() {
        return this.connectionStage.thenApply(Function.identity());
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public CompletionStage<Void> closeAsync() {
        if (this.open.compareAndSet(true, false)) {
            return this.resultCursorStage.thenCompose(cursor -> {
                if (cursor != null) {
                    return cursor.discardAllFailureAsync();
                }
                return Futures.completedWithNull();
            }).thenCompose(cursorError -> this.closeTransactionAndReleaseConnection().thenApply(txCloseError -> {
                CompletionException combinedError = Futures.combineErrors(cursorError, txCloseError);
                if (combinedError != null) {
                    throw combinedError;
                }
                return null;
            }));
        }
        return Futures.completedWithNull();
    }

    protected CompletionStage<Boolean> currentConnectionIsOpen() {
        return this.connectionStage.handle((connection, error) -> error == null && connection != null && connection.isOpen());
    }

    private void handleDatabaseName(String name) {
        this.connectionContext.databaseNameFuture.complete(DatabaseName.database((String)name));
        this.homeDatabaseCache.put(this.homeDatabaseKey, name);
    }

    private CompletionStage<BoltConnectionWithCloseTracking> acquireConnection(AccessMode mode) {
        AuthToken overrideAuthToken = this.connectionContext.overrideAuthToken();
        AuthTokenManager authTokenManager = overrideAuthToken != null ? NoopAuthTokenManager.INSTANCE : this.authTokenManager;
        CompletionStage<BoltConnectionWithCloseTracking> newConnectionStage = this.pulledResultCursorStage(this.connectionStage).thenCompose(ignored -> this.acquireAdaptedConnection(mode)).thenApply(connection -> new BoltConnectionWithAuthTokenManager((DriverBoltConnection)connection, authTokenManager)).thenApply(BoltConnectionWithCloseTracking::new).exceptionally(this::mapAcquisitionError);
        this.connectionStage = newConnectionStage.exceptionally(error -> null);
        return newConnectionStage;
    }

    private BoltConnectionWithCloseTracking mapAcquisitionError(Throwable throwable) {
        if ((throwable = Futures.completionExceptionCause(throwable)) instanceof TimeoutException) {
            throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(throwable.getMessage()), "N/A", throwable.getMessage(), GqlStatusError.DIAGNOSTIC_RECORD, throwable);
        }
        if (throwable instanceof MinVersionAcquisitionException) {
            MinVersionAcquisitionException minVersionAcquisitionException = (MinVersionAcquisitionException)throwable;
            if (this.connectionContext.overrideAuthToken() == null && this.connectionContext.impersonatedUser() != null) {
                String message = "Detected connection that does not support impersonation, please make sure to have all servers running 4.4 version or above and communicating over Bolt version 4.4 or above when using impersonation feature";
                throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
            }
            throw new CompletionException(new UnsupportedFeatureException(String.format("Detected Bolt %s connection that does not support the auth token override feature, please make sure to have all servers communicating over Bolt 5.1 or above to use the feature", minVersionAcquisitionException.version())));
        }
        throw new CompletionException(throwable);
    }

    private CompletionStage<DriverBoltConnection> acquireAdaptedConnection(AccessMode mode) {
        DatabaseName databaseName = this.connectionContext.databaseNameFuture().getNow(null);
        String impersonatedUser = this.connectionContext.impersonatedUser();
        BoltProtocolVersion minVersion = NetworkSession.minBoltVersion(this.connectionContext);
        org.neo4j.bolt.connection.AuthToken overrideAuthToken = this.connectionContext.overrideAuthToken() != null ? AuthTokens.custom(BoltValueFactory.getInstance().toBoltMap(((InternalAuthToken)this.connectionContext.overrideAuthToken()).toMap())) : null;
        org.neo4j.bolt.connection.AccessMode accessMode = NetworkSession.asBoltAccessMode(mode);
        Set bookmarks = this.connectionContext.rediscoveryBookmarks().stream().map(Bookmark::value).collect(Collectors.toSet());
        Consumer<DatabaseName> databaseNameListener = name -> {
            if (name != null) {
                if (databaseName == null) {
                    name.databaseName().ifPresent(n -> this.homeDatabaseCache.put(this.homeDatabaseKey, (String)n));
                }
            } else {
                name = DatabaseName.defaultDatabase();
            }
            this.connectionContext.databaseNameFuture().complete((DatabaseName)name);
        };
        String homeDatabaseHint = this.homeDatabaseCache.get(this.homeDatabaseKey).orElse(null);
        RoutedBoltConnectionParameters parameters = RoutedBoltConnectionParameters.builder().withAuthToken(overrideAuthToken).withMinVersion(minVersion).withAccessMode(accessMode).withDatabaseName(databaseName).withDatabaseNameListener(databaseNameListener).withHomeDatabaseHint(homeDatabaseHint).withBookmarks(bookmarks).withImpersonatedUser(impersonatedUser).build();
        return this.boltConnectionProvider.getConnection(parameters);
    }

    private CompletionStage<Void> pulledResultCursorStage(CompletionStage<BoltConnectionWithCloseTracking> connectionStage) {
        return this.resultCursorStage.thenCompose(cursor -> {
            if (cursor == null) {
                return Futures.completedWithNull();
            }
            return cursor.pullAllFailureAsync();
        }).thenCompose(error -> {
            if (error == null) {
                return connectionStage.handle((ignored, throwable) -> null);
            }
            throw new CompletionException((Throwable)error);
        });
    }

    private CompletionStage<Throwable> closeTransactionAndReleaseConnection() {
        return this.existingTransactionOrNull().thenCompose(tx -> {
            if (tx != null) {
                return tx.closeAsync().thenApply(ignore -> null).exceptionally(Function.identity());
            }
            return Futures.completedWithNull();
        }).thenCompose(txCloseError -> this.releaseConnectionAsync().thenApply(ignore -> txCloseError));
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeRunningQuery() {
        return this.ensureNoOpenTx("Queries cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeStartingTx() {
        return this.ensureNoOpenTx("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTx(String errorMessage) {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                throw new TransactionNestingException(errorMessage);
            }
        });
    }

    private CompletionStage<UnmanagedTransaction> existingTransactionOrNull() {
        return this.transactionStage.exceptionally(error -> null).thenApply(tx -> tx != null && tx.isOpen() ? tx : null);
    }

    private void ensureSessionIsOpen() {
        if (!this.open.get()) {
            String message = "No more interaction with this session are allowed as the current session is already closed. ";
            throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
        }
    }

    private void handleNewBookmark(DatabaseBookmark databaseBookmark) {
        this.assertDatabaseNameFutureIsDone();
        Bookmark bookmark = databaseBookmark.bookmark();
        if (bookmark != null) {
            Set<Bookmark> bookmarks = Set.of(bookmark);
            this.lastReceivedBookmarks = bookmarks;
            this.bookmarkManager.updateBookmarks(this.lastUsedBookmarks, bookmarks);
        }
    }

    private Set<Bookmark> determineBookmarks(boolean updateLastUsed) {
        HashSet<Bookmark> bookmarks = new HashSet<Bookmark>(this.bookmarkManager.getBookmarks());
        if (updateLastUsed) {
            this.lastUsedBookmarks = Collections.unmodifiableSet(bookmarks);
        }
        bookmarks.addAll(this.lastReceivedBookmarks);
        return bookmarks;
    }

    private void assertDatabaseNameFutureIsDone() {
        if (!this.connectionContext.databaseNameFuture().isDone()) {
            throw new IllegalStateException("Illegal internal state encountered, database name future is not done.");
        }
    }

    private RunMessage newRunMessage(DriverBoltConnection connection, Query query, Map<String, Value> parameters, TransactionConfig config) {
        return Messages.run((String)this.connectionContext.databaseNameFuture.getNow(DatabaseName.defaultDatabase()).databaseName().orElse(null), (org.neo4j.bolt.connection.AccessMode)NetworkSession.asBoltAccessMode(this.mode), (String)this.connectionContext.impersonatedUser, this.determineBookmarks(true).stream().map(Bookmark::value).collect(Collectors.toSet()), (String)query.text(), connection.valueFactory().toBoltMap(parameters), (Duration)config.timeout(), connection.valueFactory().toBoltMap(config.metadata()), (org.neo4j.bolt.connection.NotificationConfig)this.notificationConfig);
    }

    private static BoltProtocolVersion minBoltVersion(NetworkSessionConnectionContext connectionContext) {
        BoltProtocolVersion minBoltVersion = null;
        if (connectionContext.overrideAuthToken() != null) {
            minBoltVersion = new BoltProtocolVersion(5, 1);
        } else if (connectionContext.impersonatedUser() != null) {
            minBoltVersion = new BoltProtocolVersion(4, 4);
        }
        return minBoltVersion;
    }

    private static Supplier<CompletionStage<Map<String, Value>>> tokenStageSupplier(AuthToken overrideAuthToken, AuthTokenManager authTokenManager) {
        return overrideAuthToken != null ? () -> CompletableFuture.completedStage(overrideAuthToken).thenApply(token -> ((InternalAuthToken)token).toMap()) : () -> authTokenManager.getToken().thenApply(token -> ((InternalAuthToken)token).toMap());
    }

    private static org.neo4j.bolt.connection.AccessMode asBoltAccessMode(AccessMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.WRITE -> org.neo4j.bolt.connection.AccessMode.WRITE;
            case AccessMode.READ -> org.neo4j.bolt.connection.AccessMode.READ;
        };
    }

    private static class NetworkSessionConnectionContext
    implements ConnectionContext {
        private final CompletableFuture<DatabaseName> databaseNameFuture;
        private final Set<Bookmark> rediscoveryBookmarks;
        private final String impersonatedUser;
        private final AuthToken authToken;

        private NetworkSessionConnectionContext(CompletableFuture<DatabaseName> databaseNameFuture, Set<Bookmark> bookmarks, String impersonatedUser, AuthToken authToken) {
            this.databaseNameFuture = databaseNameFuture;
            this.rediscoveryBookmarks = bookmarks;
            this.impersonatedUser = impersonatedUser;
            this.authToken = authToken;
        }

        @Override
        public CompletableFuture<DatabaseName> databaseNameFuture() {
            return this.databaseNameFuture;
        }

        @Override
        public Set<Bookmark> rediscoveryBookmarks() {
            return this.rediscoveryBookmarks;
        }

        @Override
        public String impersonatedUser() {
            return this.impersonatedUser;
        }

        @Override
        public AuthToken overrideAuthToken() {
            return this.authToken;
        }
    }

    private static final class NoopAuthTokenManager
    implements AuthTokenManager {
        static final NoopAuthTokenManager INSTANCE = new NoopAuthTokenManager();

        private NoopAuthTokenManager() {
        }

        @Override
        public CompletionStage<AuthToken> getToken() {
            return null;
        }

        @Override
        public boolean handleSecurityException(AuthToken authToken, SecurityException exception) {
            return false;
        }
    }

    public static class RunRxResponseHandler
    implements DriverResponseHandler {
        private static final Lock NOOP_LOCK = new NoopLock();
        final CompletableFuture<RxResultCursor> cursorFuture = new CompletableFuture();
        private final Logging logging;
        private final DriverBoltConnection connection;
        private final Query query;
        private final Consumer<DatabaseBookmark> bookmarkConsumer;
        private final AtomicBoolean runFailed;
        private final Consumer<String> databaseNameConsumer;
        private RunSummary runSummary;
        private Throwable error;
        private int ignoredCount;

        public RunRxResponseHandler(Logging logging, DriverBoltConnection connection, Query query, Consumer<DatabaseBookmark> bookmarkConsumer, AtomicBoolean runFailed, Consumer<String> databaseNameConsumer) {
            this.logging = logging;
            this.connection = connection;
            this.query = query;
            this.bookmarkConsumer = bookmarkConsumer;
            this.runFailed = runFailed;
            this.databaseNameConsumer = Objects.requireNonNull(databaseNameConsumer);
        }

        @Override
        public void onError(Throwable throwable) {
            throwable = Futures.completionExceptionCause(throwable);
            if (this.error == null) {
                this.error = throwable;
            } else if (this.error instanceof Neo4jException && !(throwable instanceof Neo4jException)) {
                this.error = throwable;
            }
        }

        @Override
        public void onRunSummary(RunSummary summary) {
            this.runSummary = summary;
            summary.databaseName().ifPresent(this.databaseNameConsumer);
        }

        @Override
        public void onIgnored() {
            ++this.ignoredCount;
        }

        @Override
        public void onComplete() {
            if (this.runSummary != null || this.error != null) {
                if (this.error != null) {
                    this.runFailed.set(true);
                }
                this.cursorFuture.complete(new RxResultCursorImpl(this.connection, this.query, this.runSummary, this.error, this.bookmarkConsumer, true, this.logging));
            } else {
                String message = this.ignoredCount > 0 ? "Run exchange contains ignored messages." : "Unexpected state during session run.";
                this.cursorFuture.completeExceptionally(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
        }
    }

    private static class NoopLock
    implements Lock {
        private NoopLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            return null;
        }
    }
}

