/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.Objects;
import java.util.stream.LongStream;
import org.neo4j.util.Preconditions;

public final class LongRange {
    public static final LongRange EMPTY_RANGE = new LongRange(-1L, -1L);
    private final long from;
    private final long to;

    public static LongRange range(long from, long to) {
        if (to < from) {
            return EMPTY_RANGE;
        }
        LongRange.assertIsRange(from, to);
        return new LongRange(from, to);
    }

    public static LongRange join(LongRange rangeA, LongRange rangeB) {
        if (!rangeA.isAdjacent(rangeB)) {
            throw new IllegalArgumentException(String.format("Fail to join ranges %s and %s since they do not form continuous range.", rangeA, rangeB));
        }
        return LongRange.range(rangeA.from, rangeB.to);
    }

    public static void assertIsRange(long from, long to) {
        Preconditions.requireNonNegative((long)from);
        Preconditions.checkArgument((to >= from ? 1 : 0) != 0, (String)"Not a valid range. Range to [%d] must be higher or equal to range from [%d].", (Object[])new Object[]{to, from});
    }

    private LongRange(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public boolean isAdjacent(LongRange candidate) {
        if (this.isEmpty()) {
            return false;
        }
        return this.to + 1L == candidate.from;
    }

    public boolean isWithinRange(long val) {
        if (this.isEmpty()) {
            return false;
        }
        return val >= this.from && val <= this.to;
    }

    public boolean isWithinRangeExclusiveTo(long val) {
        if (this.isEmpty()) {
            return false;
        }
        return val >= this.from && val < this.to;
    }

    public LongStream stream() {
        return this.isEmpty() ? LongStream.empty() : LongStream.rangeClosed(this.from, this.to);
    }

    public boolean isEmpty() {
        return this.from == -1L;
    }

    public String toString() {
        return "LongRange{from=" + this.from + ", to=" + this.to + "}";
    }

    public long from() {
        return this.from;
    }

    public long to() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongRange longRange = (LongRange)o;
        return this.from == longRange.from && this.to == longRange.to;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }
}

