/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.routed.impl;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltServiceUnavailableException;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.routed.RoutedBoltConnectionSource;
import org.neo4j.bolt.connection.routed.impl.cluster.RoutingTableHandler;
import org.neo4j.bolt.connection.routed.impl.util.FutureUtil;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.PullSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.bolt.connection.values.Value;

public class RoutedBoltConnection
implements BoltConnection {
    private final BoltConnection delegate;
    private final RoutingTableHandler routingTableHandler;
    private final AccessMode accessMode;
    private final RoutedBoltConnectionSource source;

    public RoutedBoltConnection(BoltConnection delegate, RoutingTableHandler routingTableHandler, AccessMode accessMode, RoutedBoltConnectionSource source) {
        this.delegate = Objects.requireNonNull(delegate);
        this.routingTableHandler = Objects.requireNonNull(routingTableHandler);
        this.accessMode = Objects.requireNonNull(accessMode);
        this.source = Objects.requireNonNull(source);
    }

    public CompletionStage<Void> writeAndFlush(ResponseHandler handler, List<Message> messages) {
        return this.delegate.writeAndFlush((ResponseHandler)new RoutedResponseHandler(this.routingTableHandler, handler, this.accessMode, this.serverAddress()), messages);
    }

    public CompletionStage<Void> write(List<Message> messages) {
        return this.delegate.write(messages);
    }

    public CompletionStage<Void> forceClose(String reason) {
        return this.delegate.forceClose(reason);
    }

    public CompletionStage<Void> close() {
        this.source.decrementInUseCount(this.serverAddress());
        return this.delegate.close();
    }

    public CompletionStage<Void> setReadTimeout(Duration duration) {
        return this.delegate.setReadTimeout(duration);
    }

    public BoltConnectionState state() {
        return this.delegate.state();
    }

    public CompletionStage<AuthInfo> authInfo() {
        return this.delegate.authInfo();
    }

    public String serverAgent() {
        return this.delegate.serverAgent();
    }

    public BoltServerAddress serverAddress() {
        return this.delegate.serverAddress();
    }

    public BoltProtocolVersion protocolVersion() {
        return this.delegate.protocolVersion();
    }

    public boolean telemetrySupported() {
        return this.delegate.telemetrySupported();
    }

    public boolean serverSideRoutingEnabled() {
        return this.delegate.serverSideRoutingEnabled();
    }

    public Optional<Duration> defaultReadTimeout() {
        return this.delegate.defaultReadTimeout();
    }

    private static class RoutedResponseHandler
    implements ResponseHandler {
        private final RoutingTableHandler routingTableHandler;
        private final ResponseHandler handler;
        private final AccessMode accessMode;
        private final BoltServerAddress serverAddress;
        private boolean notifyHandler = true;

        private RoutedResponseHandler(RoutingTableHandler routingTableHandler, ResponseHandler handler, AccessMode accessMode, BoltServerAddress serverAddress) {
            this.routingTableHandler = routingTableHandler;
            this.handler = handler;
            this.accessMode = accessMode;
            this.serverAddress = serverAddress;
        }

        public void onError(Throwable throwable) {
            this.handler.onError(this.handledError(throwable, this.notifyHandler));
            this.notifyHandler = false;
        }

        public void onBeginSummary(BeginSummary summary) {
            this.handler.onBeginSummary(summary);
        }

        public void onRunSummary(RunSummary summary) {
            this.handler.onRunSummary(summary);
        }

        public void onRecord(List<Value> fields) {
            this.handler.onRecord(fields);
        }

        public void onPullSummary(PullSummary summary) {
            this.handler.onPullSummary(summary);
        }

        public void onDiscardSummary(DiscardSummary summary) {
            this.handler.onDiscardSummary(summary);
        }

        public void onCommitSummary(CommitSummary summary) {
            this.handler.onCommitSummary(summary);
        }

        public void onRollbackSummary(RollbackSummary summary) {
            this.handler.onRollbackSummary(summary);
        }

        public void onResetSummary(ResetSummary summary) {
            this.handler.onResetSummary(summary);
        }

        public void onRouteSummary(RouteSummary summary) {
            this.handler.onRouteSummary(summary);
        }

        public void onLogoffSummary(LogoffSummary summary) {
            this.handler.onLogoffSummary(summary);
        }

        public void onLogonSummary(LogonSummary summary) {
            this.handler.onLogonSummary(summary);
        }

        public void onTelemetrySummary(TelemetrySummary summary) {
            this.handler.onTelemetrySummary(summary);
        }

        public void onIgnored() {
            this.handler.onIgnored();
        }

        public void onComplete() {
            this.handler.onComplete();
        }

        private Throwable handledError(Throwable receivedError, boolean notifyHandler) {
            Throwable error = FutureUtil.completionExceptionCause(receivedError);
            if (error instanceof BoltServiceUnavailableException) {
                BoltServiceUnavailableException boltServiceUnavailableException = (BoltServiceUnavailableException)error;
                return this.handledServiceUnavailableException(boltServiceUnavailableException, notifyHandler);
            }
            if (error instanceof BoltFailureException) {
                BoltFailureException boltFailureException = (BoltFailureException)error;
                return this.handledBoltFailureException(boltFailureException, notifyHandler);
            }
            return error;
        }

        private Throwable handledServiceUnavailableException(BoltServiceUnavailableException e, boolean notifyHandler) {
            if (notifyHandler) {
                this.routingTableHandler.onConnectionFailure(this.serverAddress);
            }
            return new BoltServiceUnavailableException(String.format("Server at %s is no longer available", this.serverAddress), (Throwable)e);
        }

        private Throwable handledBoltFailureException(BoltFailureException e, boolean notifyHandler) {
            String errorCode = e.code();
            if (Objects.equals(errorCode, "Neo.TransientError.General.DatabaseUnavailable")) {
                if (notifyHandler) {
                    this.routingTableHandler.onConnectionFailure(this.serverAddress);
                }
            } else if (RoutedResponseHandler.isFailureToWrite(errorCode)) {
                switch (this.accessMode) {
                    case READ: {
                        break;
                    }
                    case WRITE: {
                        if (!notifyHandler) break;
                        this.routingTableHandler.onWriteFailure(this.serverAddress);
                    }
                }
            }
            return e;
        }

        private static boolean isFailureToWrite(String errorCode) {
            return Objects.equals(errorCode, "Neo.ClientError.Cluster.NotALeader") || Objects.equals(errorCode, "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
        }
    }
}

