/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.annotations.api.PublicApi;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.PostorderBreadthFirstSelector;
import org.neo4j.graphdb.traversal.PostorderDepthFirstSelector;
import org.neo4j.graphdb.traversal.PreorderBreadthFirstSelector;
import org.neo4j.graphdb.traversal.PreorderDepthFirstSelector;
import org.neo4j.graphdb.traversal.TraversalBranch;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@PublicApi
public enum BranchOrderingPolicies implements BranchOrderingPolicy
{
    PREORDER_DEPTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
            return new PreorderDepthFirstSelector(startSource, expander);
        }
    }
    ,
    POSTORDER_DEPTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
            return new PostorderDepthFirstSelector(startSource, expander);
        }
    }
    ,
    PREORDER_BREADTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
            return new PreorderBreadthFirstSelector(startSource, expander);
        }
    }
    ,
    POSTORDER_BREADTH_FIRST{

        @Override
        public BranchSelector create(TraversalBranch startSource, PathExpander expander) {
            return new PostorderBreadthFirstSelector(startSource, expander);
        }
    };

}

